/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACCallback;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.rlb.OracleDatabaseInstanceInfo;

public class RACCallbackGuard
implements RACManagerImpl.RACCallbackExtended {
    static final String CLASS_NAME = RACCallbackGuard.class.getName();
    final RACCallback racCallback;

    RACCallbackGuard() {
        this(null);
    }

    RACCallbackGuard(RACCallback racCallback) {
        this.racCallback = racCallback;
    }

    private static void logUnregistered() {
        DiagnosticsCollectorImpl.getCommon().trace(Level.CONFIG, CLASS_NAME, "logUnregistered", "RAC callback is unregistered", null, null, new Object[0]);
    }

    private static void logNonExtended() {
        DiagnosticsCollectorImpl.getCommon().trace(Level.CONFIG, CLASS_NAME, "logNonExtended", "RAC callback does not implement extended interface", null, null, new Object[0]);
    }

    private static void logThrowable(Throwable e) {
        DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "logNonExtended", "RAC callback: guarded method threw exception", null, null, new Object[0]);
        DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "logThrowable", "", null, e, new Object[0]);
    }

    @Override
    public void initiateDownEventProcessing(OracleFailoverEvent event) throws UniversalConnectionPoolException {
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                this.racCallback.initiateDownEventProcessing(event);
            }
            catch (UniversalConnectionPoolException e) {
                throw e;
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
    }

    @Override
    public int initiateUpEventProcessing(OracleFailoverEvent event) throws UniversalConnectionPoolException {
        int res = 0;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.initiateUpEventProcessing(event);
            }
            catch (UniversalConnectionPoolException e) {
                throw e;
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public FailoverablePooledConnection openNewConnection(String url, RACInstance racInstance) throws UniversalConnectionPoolException {
        FailoverablePooledConnection res = null;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.openNewConnection(url, racInstance);
            }
            catch (UniversalConnectionPoolException e) {
                throw e;
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public String getUrl() {
        String res = "raccallback-unregistered";
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getUrl();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public String getPoolName() {
        String res = "raccallback-unregistered";
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getPoolName();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public int getMinPoolSize() {
        int res = 0;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getMinPoolSize();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public int getMaxPoolSize() {
        int res = 0;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getMaxPoolSize();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public int getRoomToGrowPool() {
        int res = 0;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getRoomToGrowPool();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public int getTotalConnectionsCount() {
        int res = 0;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getTotalConnectionsCount();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        boolean res = false;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getValidateConnectionOnBorrow();
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public boolean isValid(FailoverablePooledConnection fpc) {
        boolean res = false;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.isValid(fpc);
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public FailoverablePooledConnection getAvailableConnectionToInstance(ConnectionRetrievalInfo cri, RACInstance racInstance) throws UniversalConnectionPoolException {
        FailoverablePooledConnection res = null;
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getAvailableConnectionToInstance(cri, racInstance);
            }
            catch (UniversalConnectionPoolException e) {
                throw e;
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public Collection<FailoverablePooledConnection> getAvailableConnections(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        Collection<FailoverablePooledConnection> res = new ArrayList<FailoverablePooledConnection>();
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                res = this.racCallback.getAvailableConnections(cri);
            }
            catch (UniversalConnectionPoolException e) {
                throw e;
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
        return res;
    }

    @Override
    public void lbaEventOccurred(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else {
            try {
                this.racCallback.lbaEventOccurred(rlbEvent);
            }
            catch (UniversalConnectionPoolException e) {
                throw e;
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
    }

    @Override
    public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo dbi, int count) {
        if (null == this.racCallback) {
            RACCallbackGuard.logUnregistered();
        } else if (!(this.racCallback instanceof RACManagerImpl.RACCallbackExtended)) {
            RACCallbackGuard.logNonExtended();
        } else {
            try {
                ((RACManagerImpl.RACCallbackExtended)this.racCallback).tearDownConnectionsForInstance(dbi, count);
            }
            catch (Throwable e) {
                RACCallbackGuard.logThrowable(e);
            }
        }
    }
}

