/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RelabelNode
extends TsurgeonPattern {
    private static final Pattern regexPattern = Pattern.compile("/(.*)/");
    private static final Pattern substPattern = Pattern.compile("/(.*[^\\\\])/(.*)/");
    private final boolean fixedNewLabel;
    private String newLabel;
    private Pattern labelRegex;
    private String replacementString;

    public RelabelNode(TsurgeonPattern child, String newLabel) {
        super("relabel", new TsurgeonPattern[]{child});
        Matcher m1 = substPattern.matcher(newLabel);
        if (m1.matches()) {
            this.fixedNewLabel = false;
            this.labelRegex = Pattern.compile(m1.group(1));
            this.replacementString = m1.group(2);
        } else {
            this.fixedNewLabel = true;
            Matcher m2 = regexPattern.matcher(newLabel);
            if (m2.matches()) {
                String unescapedLabel = m2.group(1);
                this.newLabel = RelabelNode.removeEscapeSlashes(unescapedLabel);
            } else {
                this.newLabel = newLabel;
            }
        }
    }

    private static String removeEscapeSlashes(String in) {
        StringBuilder out2 = new StringBuilder();
        int len = in.length();
        boolean lastIsBackslash = false;
        for (int i = 0; i < len; ++i) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                if (lastIsBackslash || i == len - 1) {
                    out2.append(ch);
                    lastIsBackslash = false;
                    continue;
                }
                lastIsBackslash = true;
                continue;
            }
            out2.append(ch);
            lastIsBackslash = false;
        }
        return out2.toString();
    }

    public Tree evaluate(Tree t, TregexMatcher tm) {
        Tree nodeToRelabel = this.children[0].evaluate(t, tm);
        if (this.fixedNewLabel) {
            nodeToRelabel.label().setValue(this.newLabel);
        } else {
            Matcher m = this.labelRegex.matcher(nodeToRelabel.label().value());
            nodeToRelabel.label().setValue(m.replaceAll(this.replacementString));
        }
        return t;
    }

    public String toString() {
        String result = this.fixedNewLabel ? this.label + '(' + this.children[0].toString() + ',' + this.newLabel + ')' : this.label + '(' + this.children[0].toString() + ',' + this.labelRegex.toString() + ',' + this.replacementString + ')';
        return result;
    }
}

