/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.components;

import io.github.dmlloyd.classfile.ClassFile;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.ClassTransform;
import io.github.dmlloyd.classfile.CodeTransform;
import io.github.dmlloyd.classfile.FieldTransform;
import io.github.dmlloyd.classfile.MethodTransform;
import io.github.dmlloyd.classfile.impl.ClassRemapperImpl;
import java.lang.constant.ClassDesc;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassRemapper
extends ClassTransform {
    public static ClassRemapper of(Map<ClassDesc, ClassDesc> classMap) {
        Objects.requireNonNull(classMap);
        return ClassRemapper.of((ClassDesc desc) -> classMap.getOrDefault(desc, (ClassDesc)desc));
    }

    public static ClassRemapper of(Function<ClassDesc, ClassDesc> mapFunction) {
        return new ClassRemapperImpl(Objects.requireNonNull(mapFunction));
    }

    public ClassDesc map(ClassDesc var1);

    public FieldTransform asFieldTransform();

    public MethodTransform asMethodTransform();

    public CodeTransform asCodeTransform();

    default public byte[] remapClass(ClassFile context, ClassModel clm) {
        return context.transformClass(clm, this.map(clm.thisClass().asSymbol()), (ClassTransform)this);
    }
}

