/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.keycloak.config.LoggingOptions;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import picocli.CommandLine;

@CommandLine.Command(name="install", header={"Install Keycloak as a Windows service."}, description={"%nInstall a Windows service that runs Keycloak using 'kc.bat start'.", "", "This command requires prunsrv.exe to be present in the bin directory.", "Download it from https://downloads.apache.org/commons/daemon/binaries/windows/", "", "The service runs in exe mode, executing kc.bat as an external process.", "This means all environment variables and configuration files are respected.", "", "For faster startup, run 'kc.bat build' before installing the service.", "Without a pre-build, the first service start will be slower as it builds."}, footerHeading="Examples:", footer={"  Install with default settings:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME}%n%n  Install with custom service name:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --name=my-keycloak%n%n  Install with dependencies on other services:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --depends-on=\"postgresql-x64-15;Tcpip\"%n"})
public class WindowsServiceInstall
extends AbstractCommand {
    public static final String NAME = "install";
    public static final String SERVICE_PASSWORD_ENV = "KC_SERVICE_PASSWORD";
    private static final String DEFAULT_SERVICE_NAME = "keycloak";
    private static final String DEFAULT_DISPLAY_NAME = "Keycloak Server";
    private static final String DEFAULT_DESCRIPTION = "Keycloak Identity and Access Management";
    @CommandLine.Option(names={"--name"}, description={"The name of the Windows service."}, defaultValue="keycloak")
    String serviceName;
    @CommandLine.Option(names={"--display-name"}, description={"The display name of the Windows service."}, defaultValue="Keycloak Server")
    String displayName;
    @CommandLine.Option(names={"--description"}, description={"The description of the Windows service."}, defaultValue="Keycloak Identity and Access Management")
    String description;
    @CommandLine.Option(names={"--startup"}, description={"Service startup mode: auto, manual."}, defaultValue="auto")
    String startupMode;
    @CommandLine.Option(names={"--service-user"}, description={"The user account the service should run as. Defaults to LocalSystem."})
    String serviceUser;
    @CommandLine.Option(names={"--service-password"}, description={"The password for the service user account. Can also be set via the KC_SERVICE_PASSWORD environment variable."})
    String servicePassword;
    @CommandLine.Option(names={"--stop-timeout"}, description={"Timeout in seconds to wait for service to stop gracefully."}, defaultValue="30")
    Integer stopTimeout;
    @CommandLine.Option(names={"--depends-on"}, description={"Services that must start before this service. Separate multiple services with semicolons (e.g., \"postgresql-x64-15;Tcpip\")."})
    String dependsOn;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isHelpAll() {
        return false;
    }

    @Override
    protected void runCommand() {
        Path logPath;
        Optional<String> logFileOption;
        Path kcBatPath;
        Path homePath;
        Path prunsrvPath;
        if (!Environment.isWindows()) {
            this.executionError(this.spec.commandLine(), "Windows service management is only available on Windows.");
        }
        if (this.servicePassword == null || this.servicePassword.isEmpty()) {
            this.servicePassword = System.getenv(SERVICE_PASSWORD_ENV);
        }
        if (!Files.exists(prunsrvPath = (homePath = Environment.getHomePath().orElseThrow(() -> new CommandLine.ExecutionException(this.spec.commandLine(), "Could not determine Keycloak home directory"))).resolve("bin").resolve("prunsrv.exe"), new LinkOption[0])) {
            this.picocli.println("Looking for prunsrv.exe in: " + String.valueOf(prunsrvPath));
            this.picocli.println("Download from https://downloads.apache.org/commons/daemon/binaries/windows/");
            this.executionError(this.spec.commandLine(), "Apache Commons Daemon (Procrun) executable not found at " + String.valueOf(prunsrvPath));
        }
        if (!Files.exists(kcBatPath = homePath.resolve("bin").resolve("kc.bat"), new LinkOption[0])) {
            this.executionError(this.spec.commandLine(), "kc.bat not found at " + String.valueOf(kcBatPath));
        }
        if ((logFileOption = Configuration.getOptionalKcValue(LoggingOptions.LOG_FILE)).isPresent()) {
            Path logFile = Path.of(logFileOption.get(), new String[0]);
            if (!logFile.isAbsolute()) {
                logFile = homePath.resolve(logFile);
            }
            logPath = logFile.getParent();
        } else {
            logPath = homePath.resolve("data").resolve("log");
        }
        try {
            Files.createDirectories(logPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.executionError(this.spec.commandLine(), "Failed to create log directory: " + String.valueOf(logPath), e);
        }
        this.picocli.println("Creating Keycloak Windows service '" + this.serviceName + "'...");
        this.picocli.println("Service will run: " + String.valueOf(kcBatPath) + " start");
        List<String> command = this.buildPrunsrvCommand(prunsrvPath, homePath, kcBatPath, logPath);
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                this.picocli.println("Service '" + this.serviceName + "' installed successfully.");
                if (this.serviceUser == null) {
                    this.picocli.println("Service is configured to run as Local System account.");
                }
                this.picocli.println("");
                this.picocli.println("To start the service, run as Administrator:");
                this.picocli.println("   net start " + this.serviceName);
            } else {
                this.executionError(this.spec.commandLine(), "Failed to install service '" + this.serviceName + "'. Exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            this.executionError(this.spec.commandLine(), "Failed to execute prunsrv: " + e.getMessage(), e);
        }
    }

    private List<String> buildPrunsrvCommand(Path prunsrvPath, Path homePath, Path kcBatPath, Path logPath) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(prunsrvPath.toString());
        cmd.add(NAME);
        cmd.add(this.serviceName);
        cmd.add("--DisplayName=" + this.displayName);
        cmd.add("--Description=" + this.description);
        cmd.add("--Startup=" + this.startupMode);
        cmd.add("--StartMode=exe");
        cmd.add("--StartPath=" + String.valueOf(homePath));
        cmd.add("--StartImage=" + String.valueOf(kcBatPath));
        cmd.add("--StartParams=start");
        cmd.add("--StopMode=exe");
        cmd.add("--StopPath=" + String.valueOf(homePath));
        cmd.add("--StopImage=" + String.valueOf(kcBatPath));
        cmd.add("--StopParams=stop");
        cmd.add("--StopTimeout=" + this.stopTimeout);
        if (this.dependsOn != null && !this.dependsOn.isEmpty()) {
            cmd.add("++DependsOn=" + this.dependsOn);
        }
        cmd.add("--LogPath=" + String.valueOf(logPath));
        cmd.add("--LogLevel=Info");
        if (this.serviceUser != null && !this.serviceUser.isEmpty()) {
            this.picocli.println("Configuring service to run as user: " + this.serviceUser);
            cmd.add("--ServiceUser=" + this.serviceUser);
            if (this.servicePassword != null && !this.servicePassword.isEmpty()) {
                cmd.add("--ServicePassword=" + this.servicePassword);
            }
        } else {
            this.picocli.println("Configuring service to run as Local System account");
            cmd.add("--ServiceUser=LocalSystem");
        }
        return cmd;
    }
}

