/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Optional;
import sun.security.ec.ECDSAOperations;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECOperations;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.jca.JCAUtil;
import sun.security.util.ECUtil;

abstract class ECDSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private SecureRandom random;
    private boolean needsReset;
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private ECParameterSpec sigParams = null;

    ECDSASignature() {
        this.messageDigest = null;
    }

    ECDSASignature(String string) {
        try {
            this.messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        ECPublicKey eCPublicKey = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        if (!ECDSASignature.isCompatible(this.sigParams, eCPublicKey.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.publicKey = eCPublicKey;
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        ECPrivateKey eCPrivateKey = (ECPrivateKey)ECKeyFactory.toECKey(privateKey);
        if (!ECDSASignature.isCompatible(this.sigParams, eCPrivateKey.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        this.privateKey = eCPrivateKey;
        this.publicKey = null;
        this.random = secureRandom;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.messageDigest.update(by);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.messageDigest.update(byArray, n, n2);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return;
        }
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    private static boolean isCompatible(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (eCParameterSpec == null) {
            return true;
        }
        return ECUtil.equals(eCParameterSpec, eCParameterSpec2);
    }

    private byte[] signDigestImpl(ECDSAOperations eCDSAOperations, int n, byte[] byArray, ECPrivateKeyImpl eCPrivateKeyImpl, SecureRandom secureRandom) throws SignatureException {
        byte[] byArray2 = new byte[(n + 7) / 8];
        byte[] byArray3 = eCPrivateKeyImpl.getArrayS();
        int n2 = 128;
        for (int i = 0; i < n2; ++i) {
            secureRandom.nextBytes(byArray2);
            ECDSAOperations.Seed seed = new ECDSAOperations.Seed(byArray2);
            try {
                return eCDSAOperations.signDigest(byArray3, byArray, seed);
            }
            catch (ECOperations.IntermediateValueException intermediateValueException) {
                continue;
            }
        }
        throw new SignatureException("Unable to produce signature after " + n2 + " attempts");
    }

    private Optional<byte[]> signDigestImpl(ECPrivateKey eCPrivateKey, byte[] byArray, SecureRandom secureRandom) throws SignatureException {
        if (!(eCPrivateKey instanceof ECPrivateKeyImpl)) {
            return Optional.empty();
        }
        ECPrivateKeyImpl eCPrivateKeyImpl = (ECPrivateKeyImpl)eCPrivateKey;
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        int n = eCParameterSpec.getOrder().bitLength() + 64;
        Optional<ECDSAOperations> optional = ECDSAOperations.forParameters(eCParameterSpec);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        byte[] byArray2 = this.signDigestImpl(optional.get(), n, byArray, eCPrivateKeyImpl, secureRandom);
        return Optional.of(byArray2);
    }

    private byte[] signDigestNative(ECPrivateKey eCPrivateKey, byte[] byArray, SecureRandom secureRandom) throws SignatureException {
        byte[] byArray2 = eCPrivateKey.getS().toByteArray();
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        byte[] byArray3 = ECUtil.encodeECParameterSpec(null, eCParameterSpec);
        int n = eCParameterSpec.getOrder().bitLength();
        byte[] byArray4 = new byte[((n + 7 >> 3) + 1) * 2];
        secureRandom.nextBytes(byArray4);
        int n2 = secureRandom.nextInt();
        n2 |= 1;
        try {
            return ECDSASignature.signDigest(byArray, byArray2, byArray3, byArray4, n2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Could not sign data", generalSecurityException);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        Optional<byte[]> optional;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        byte[] byArray2 = (optional = this.signDigestImpl(this.privateKey, byArray = this.getDigestValue(), this.random)).isPresent() ? optional.get() : this.signDigestNative(this.privateKey, byArray, this.random);
        return ECUtil.encodeSignature(byArray2);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        ECParameterSpec eCParameterSpec = this.publicKey.getParams();
        byte[] byArray2 = ECUtil.encodeECParameterSpec(null, eCParameterSpec);
        byte[] byArray3 = this.publicKey instanceof ECPublicKeyImpl ? ((ECPublicKeyImpl)this.publicKey).getEncodedPublicValue() : ECUtil.encodePoint(this.publicKey.getW(), eCParameterSpec.getCurve());
        try {
            return ECDSASignature.verifySignedDigest(ECUtil.decodeSignature(byArray), this.getDigestValue(), byArray3, byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Could not verify signature", generalSecurityException);
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Key key;
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
        Key key2 = key = this.privateKey == null ? this.publicKey : this.privateKey;
        if (key != null && !ECDSASignature.isCompatible((ECParameterSpec)algorithmParameterSpec, key.getParams())) {
            throw new InvalidAlgorithmParameterException("Signature params does not match key params");
        }
        this.sigParams = (ECParameterSpec)algorithmParameterSpec;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
            algorithmParameters.init(this.sigParams);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new ProviderException("Error retrieving EC parameters", exception);
        }
    }

    private static native byte[] signDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4) throws GeneralSecurityException;

    private static native boolean verifySignedDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3) throws GeneralSecurityException;

    public static final class SHA512
    extends ECDSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA224
    extends ECDSASignature {
        public SHA224() {
            super("SHA-224");
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class Raw
    extends ECDSASignature {
        private static final int RAW_ECDSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = by;
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            System.arraycopy(byArray, n, this.precomputedDigest, this.offset, n2);
            this.offset += n2;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            if (this.offset + n >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, n);
            this.offset += n;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            byte[] byArray = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, byArray, 0, this.offset);
            this.offset = 0;
            return byArray;
        }
    }
}

