---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Vulnerability management policy schema
---

The YAML file with vulnerability management policies consists of an array of objects matching
the vulnerability management policy schema nested under the `vulnerability_management_policy` key.

When you save a vulnerability management policy, its content is validated against the vulnerability
management policy schema. If you're not familiar with how to read
[JSON schemas](https://json-schema.org/), the following sections and tables provide an alternative.

| Field                             | Type                                       | Required | Description |
|-----------------------------------|--------------------------------------------|----------|-------------|
| `vulnerability_management_policy` | `array` of vulnerability management policy | true     | List of vulnerability management policies (maximum 5) |

## Vulnerability management policy

| Field          | Type                                         | Required | Description |
|----------------|----------------------------------------------|----------|-------------|
| `name`         | `string`                                     | true     | Name of the policy. Maximum of 255 characters. |
| `description`  | `string`                                     | false    | Description of the policy. |
| `enabled`      | `boolean`                                    | true     | Flag to enable (`true`) or disable (`false`) the policy. |
| `rules`        | `array` of rules                             | true     | List of rules that define the policy's criteria (maximum 5). |
| `policy_scope` | `object` of [`policy_scope`](_index.md#configure-the-policy-scope) | false    | Scope of the policy, based on the projects, groups, or compliance framework labels you specify. |
| `actions`      | `array` of actions                           | true     | Action to be taken on vulnerabilities matching the policy. |

### `no_longer_detected` rule

This rule defines the criteria for auto-resolve policies.

| Field | Type | Required | Possible values | Description |
|-------|------|----------|-----------------|-------------|
| `type` | `string` | true | `no_longer_detected` | The rule's type. |
| `scanners` | `array` | `true` | `sast`, `secret_detection`, `dependency_scanning`, `container_scanning`, `dast`, `coverage_fuzzing`, `api_fuzzing` | Specifies the scanners for which this policy is enforced. |
| `severity_levels` | `array` | `true` | `critical`, `high`, `medium`, `low`, `info`, `unknown` | Specifies the severity levels for which this policy is enforced. |

### `detected` rule

This rule defines the criteria for policies with auto-dismiss actions.

| Field | Type | Required | Possible values | Description |
|-------|------|----------|-----------------|-------------|
| `type` | `string` | true | `detected` | The rule's type. |
| `criteria` | `array` of criteria objects | true | | List of criteria. Vulnerability must match all criteria for the rule to apply. Maximum of 3 criteria. |

#### Criteria object

| Field | Type | Required | Possible values | Description |
|-------|------|----------|-----------------|-------------|
| `type` | `string` | true | `file_path`, `directory`, `identifier` | The type of criteria the vulnerabilities must match. |
| `value` | `string` | true | | The value that the vulnerabilities must match. Supports glob patterns for `file_path` and `directory`, and wildcard patterns for `identifier`. |

Criteria types:

- `file_path`: Matches the file path where the vulnerability was found. Supports glob patterns like `test/**/*`.
- `directory`: Matches the directory containing the vulnerable file. Supports glob patterns like `vendor/*`.
- `identifier`: Matches vulnerability identifiers (CVE, CWE, scanner-specific). Supports wildcard patterns like `CVE-2023-*`.

### `auto_resolve` action

This action resolves vulnerabilities matching the policy's rules and scope.

| Field  | Type     | Required | Possible values | Description |
|--------|----------|----------|-----------------|-------------|
| `type` | `string` | true     | `auto_resolve`  | The action's type. |

### `auto_dismiss` action

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/10894) support for auto-dismiss policies in GitLab 18.8 for the group-level [with a flag](../../../administration/feature_flags/_index.md) named `auto_dismiss_vulnerability_policies`. Enabled by default.

{{< /history >}}

This action dismisses vulnerabilities matching the policy's rules and scope.

| Field  | Type     | Required | Possible values | Description |
|--------|----------|----------|-----------------|-------------|
| `type` | `string` | true     | `auto_dismiss`  | The action's type. |
| `dismissal_reason` | `string` | true | `acceptable_risk`, `false_positive`, `mitigating_control`, `used_in_tests`, `not_applicable` | The reason for dismissing the vulnerability. |

Dismissal reasons:

- `acceptable_risk`: The vulnerability is known and accepted as a business risk.
- `false_positive`: The vulnerability is incorrectly reported.
- `mitigating_control`: Equivalent protection is provided by other controls.
- `used_in_tests`: The vulnerability is part of test code or test data.
- `not_applicable`: The vulnerability is in code that will not be updated.

## Example vulnerability management policy

```yaml
vulnerability_management_policy:
- name: "Auto-dismiss test vulnerabilities"
  description: "Automatically dismiss vulnerabilities found in test files"
  enabled: true
  rules:
  - type: detected
    criteria:
    - type: file_path
      value: "test/**/*"
    - type: identifier
      value: "CVE-2023-*"
  actions:
  - type: auto_dismiss
    dismissal_reason: used_in_tests
- name: "Auto-resolve no longer detected SAST vulnerabilities"
  description: "Automatically resolve SAST vulnerabilities that are no longer detected"
  enabled: true
  rules:
  - type: no_longer_detected
    scanners:
    - sast
    severity_levels:
    - high
    - critical
  actions:
  - type: auto_resolve
```
