---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Other upgrade paths
description: Move between different editions or installation methods.
---

Not all upgrades are from one version of GitLab to another. Other paths are available.

## Convert to Enterprise Edition

You can convert your GitLab Community Edition (CE) instance to a GitLab Enterprise Edition (EE) instance:

- [Convert a Linux package instance to EE](package.md)
- [Convert a Docker instance to EE](docker.md)
- [Convert a self-compiled instance to EE](self_compiled.md)
- [Convert a GitLab Helm chart instance to EE](https://docs.gitlab.com/charts/installation/deployment/#convert-community-edition-to-enterprise-edition)

If required, you can [revert from Enterprise Edition to Community Edition](revert.md).

## Convert a self-compiled instance to a Linux package

If you have a self-compiled GitLab instance, you can
[convert a self-compiled GitLab instance to Linux package](https://docs.gitlab.com/omnibus/update/convert_to_omnibus/).
