---
stage: Package
group: Package Registry
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: パッケージレジストリのストレージを削減する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

パッケージレジストリは、時間の経過とともにパッケージとそのアセットを蓄積します。定期的なクリーンアップを行わないと、:

- パッケージリストのフェッチに時間がかかり、CI/CDパイプラインのパフォーマンスに影響します。
- サーバーは、未使用または古いパッケージに対してより多くのストレージ容量を割り当てます。
- ユーザーは、多数の古いパッケージバージョンの間で関連するパッケージを見つけるのに苦労する可能性があります。

定期的なクリーンアップポリシーを実装して、パッケージレジストリの肥大化を軽減し、ストレージを解放する必要があります。

## パッケージレジストリのストレージ使用量を確認する {#review-package-registry-storage-use}

ストレージの**使用状況の内訳**を確認するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **使用量クォータ**を選択します。
1. **使用量クォータ**ページで、パッケージの**使用状況の内訳**を確認します。

## パッケージを削除する {#delete-a-package}

パッケージレジストリにパッケージを公開した後、編集することはできません。代わりに、パッケージを削除して再公開する必要があります。

前提要件: 

- メンテナーロール以上が必要です。

パッケージを削除するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **デプロイ** > **パッケージレジストリ**を選択します。
1. **パッケージレジストリ**ページで、削除するパッケージを選択します。
   - または、**パッケージレジストリ**ページで、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**パッケージの削除**を選択します。
1. **削除**を選択します。

パッケージは完全に削除されます。

パッケージを[削除](../../../api/packages.md#delete-a-project-package)するには、APIを使用することもできます。

{{< alert type="note" >}}

[リクエスト転送](supported_functionality.md#forwarding-requests)が有効になっているときにパッケージを削除すると、[依存関係の混乱リスク](supported_functionality.md#deleting-packages)が発生する可能性があります。

{{< /alert >}}

## パッケージアセットの削除 {#delete-package-assets}

ストレージを削減するには、パッケージに関連付けられたアセットを削除します。

前提要件: 

- デベロッパーロール以上が必要です。

パッケージアセットを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **デプロイ** > **パッケージレジストリ**を選択します。
1. **パッケージレジストリ**ページで、詳細を表示するパッケージを選択します。
1. **アセット**テーブルで、削除するアセットの名前を見つけます。
1. 縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**アセットを削除**を選択します。

パッケージアセットは完全に削除されます。

パッケージを[削除](../../../api/packages.md#delete-a-package-file)するには、APIを使用することもできます。

## クリーンアップポリシー {#cleanup-policy}

{{< history >}}

- GitLab 15.2で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/346153)されました。

{{< /history >}}

パッケージレジストリに同じ名前とバージョンのパッケージをアップロードすると、より多くのアセットがパッケージに追加されます。

ストレージ容量を節約するには、最新のアセットのみを保持する必要があります。クリーンアップポリシーを使用して、プロジェクト内のパッケージアセットを自動的に削除するルールを定義します。これにより、手動で削除する必要がなくなります。

### クリーンアップポリシーを有効にする {#enable-the-cleanup-policy}

前提要件: 

- メンテナーロール以上が必要です。

デフォルトでは、パッケージのクリーンアップポリシーは無効になっています。有効にするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **パッケージとレジストリ**を選択します。
1. **パッケージレジストリ**を展開します。
1. **パッケージアセットで使用されたストレージを管理**アセットで使用されたストレージの管理]で、ルールを適切に設定します。

### 利用可能なルール {#available-rules}

- `Number of duplicated assets to keep`: パッケージ形式によっては、同じアセットの複数のコピーがサポートされる場合があります。保持する重複アセットの数に制限を設定できます。制限に達すると、最も古いアセットが自動的に削除されます。Mavenスナップショットによって生成されるものなど、一意のファイル名は重複アセットとしてカウントされません。

- `Number of duplicated assets to keep`は[12時間ごと](https://gitlab.com/gitlab-org/gitlab/-/blob/master/app/models/packages/cleanup/policy.rb)に実行されます。

### リソースを節約するためにクリーンアップ制限を設定する {#set-cleanup-limits-to-conserve-resources}

バックグラウンドプロセスは、パッケージのクリーンアップポリシーを実行します。このプロセスは、完了までに長い時間がかかる場合があり、実行中にサーバーリソースを消費します。

次の設定を使用して、クリーンアップワーカーの数を制限します:

- `package_registry_cleanup_policies_worker_capacity`: 同時に実行されるクリーンアップワーカーの最大数。この数は、`0`以上である必要があります。小さい数から始めて、バックグラウンドワーカーが使用するリソースをモニタリングした後で増やすことをおすすめします。すべてのワーカーを削除してクリーンアップポリシーを実行しないようにするには、この設定を`0`に設定します。デフォルト値は`2`です。
