---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLab Advanced SAST CWEカバレッジ
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[GitLab Advanced SAST](gitlab_advanced_sast.md)は、[サポートされている言語](gitlab_advanced_sast.md#supported-languages)で記述されたコード内の潜在的なセキュリティ脆弱性を多数検出します。

GitLabは、一致する[Common Weakness Enumeration（CWE）](https://cwe.mitre.org)識別子を、潜在的な脆弱性ごとに割り当てます。CWE識別子は、セキュリティ上の弱点を特定するための業界標準の方法ですが、以下の点を知っておくことが重要です:

- CWEはツリー構造で配置されています。例: [CWE-22: パストラバーサル](https://cwe.mitre.org/data/definitions/22.html)は、[CWE-23の親です: 相対パストラバーサル](https://cwe.mitre.org/data/definitions/23.html)。スキャナーは、定義により、相対パストラバーサルの弱点（CWE-23）を特に検出する場合、より一般的なパストラバーサルカテゴリ（CWE-22）の一部も検出します。
- 明確にするため、この表では、GitLab Advanced SASTルールに割り当てられている正確なCWE識別子を示します。親識別子はレポートしません。

GitLab Advanced SASTで使用されているルールの詳細については、[SASTルール](rules.md#gitlab-advanced-sast)を参照してください。

## 言語別のCWEカバレッジ {#cwe-coverage-by-language}

GitLab Advanced SASTは、各プログラミング言語で次の種類の弱点を検出します:

<!-- Table contents are automatically produced by a job in https://gitlab.com/gitlab-org/security-products/oxeye/product/oxeye-rulez. -->

| CWE                                                          | CWEの説明                                                                                                        | C                                    | C++                                  | C#                                   | Go                                   | Java                                 | JavaScript、TypeScript               | PHP                                  | Python                               | Ruby                                 |
|:-------------------------------------------------------------|:-----------------------------------------------------------------------------------------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|:-------------------------------------|
| [CWE-15](https://cwe.mitre.org/data/definitions/15.html)     | システムまたは構成設定の外部制御                                                                    | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-22](https://cwe.mitre.org/data/definitions/22.html)     | 制限されたディレクトリへのパス名の不適切な制限（「パストラバーサル」）                                         | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-23](https://cwe.mitre.org/data/definitions/23.html)     | 相対パストラバーサル                                                                                                | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-73](https://cwe.mitre.org/data/definitions/73.html)     | ファイル名またはパスの外部制御                                                                                  | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-76](https://cwe.mitre.org/data/definitions/76.html)     | 同等の特殊要素の不適切な無効化                                                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-77](https://cwe.mitre.org/data/definitions/77.html)     | コマンドで使用される特殊要素の不適切な無効化（「コマンドインジェクション」）                                    | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-78](https://cwe.mitre.org/data/definitions/78.html)     | OSコマンドで使用される特殊要素の不適切な無効化（「OSコマンドインジェクション」）                             | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-79](https://cwe.mitre.org/data/definitions/79.html)     | Webページ生成中の入力の不適切な無効化（「クロスサイトスクリプティング」）                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-80](https://cwe.mitre.org/data/definitions/80.html)     | Webページ内のスクリプト関連HTMLタグの不適切な無効化（基本クロスサイトスクリプティング）                                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-88](https://cwe.mitre.org/data/definitions/88.html)     | コマンド内の引数デリミターの不適切な無効化（「引数インジェクション」）                                     | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-89](https://cwe.mitre.org/data/definitions/89.html)     | SQLコマンドで使用される特殊要素の不適切な無効化（「SQLインジェクション」）                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-90](https://cwe.mitre.org/data/definitions/90.html)     | LDAPクエリで使用される特殊要素の不適切な無効化（「LDAPインジェクション」）                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-91](https://cwe.mitre.org/data/definitions/91.html)     | XMLインジェクション（別名Blind XPath Injection）                                                                              | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-94](https://cwe.mitre.org/data/definitions/94.html)     | コード生成の不適切な制御（「コードインジェクション」）                                                              | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-95](https://cwe.mitre.org/data/definitions/95.html)     | 動的に評価されるコード内のディレクティブの不適切な無効化（「Eval Injection」）                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-113](https://cwe.mitre.org/data/definitions/113.html)   | HTTPヘッダー内のCRLFシーケンスの不適切な無効化（「HTTPリクエスト/レスポンスの分割」）                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-116](https://cwe.mitre.org/data/definitions/116.html)   | 出力の不適切なエンコードまたはエスケープ                                                                                | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-117](https://cwe.mitre.org/data/definitions/117.html)   | ログの不適切な出力の無効化                                                                                | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-118](https://cwe.mitre.org/data/definitions/118.html)   | インデックス可能なリソースの不正なアクセス（「範囲エラー」）                                                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-125](https://cwe.mitre.org/data/definitions/125.html)   | 範囲外読み取り                                                                                                     | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-131](https://cwe.mitre.org/data/definitions/131.html)   | バッファサイズの不正な計算                                                                                   | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-155](https://cwe.mitre.org/data/definitions/155.html)   | ワイルドカードまたは一致するシンボルの不適切な無効化                                                               | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-180](https://cwe.mitre.org/data/definitions/180.html)   | 不正な動作順序: 正準化の前に検証する                                                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-182](https://cwe.mitre.org/data/definitions/182.html)   | データの安全でない値への折りたたみ                                                                                     | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-185](https://cwe.mitre.org/data/definitions/185.html)   | 不正な正規表現                                                                                           | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-190](https://cwe.mitre.org/data/definitions/190.html)   | 整数のオーバーフローまたはラップアラウンド                                                                                         | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-191](https://cwe.mitre.org/data/definitions/191.html)   | 整数のアンダーフロー（ラップまたはラップアラウンド）                                                                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-208](https://cwe.mitre.org/data/definitions/208.html)   | 観察可能なタイミングの矛盾                                                                                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-209](https://cwe.mitre.org/data/definitions/209.html)   | 機密情報を含むエラーメッセージの生成                                                           | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-242](https://cwe.mitre.org/data/definitions/242.html)   | 本質的に危険な関数の使用                                                                                   | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-256](https://cwe.mitre.org/data/definitions/256.html)   | パスワードの平文ストレージ                                                                                        | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-272](https://cwe.mitre.org/data/definitions/272.html)   | 最小特権の違反                                                                                              | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-276](https://cwe.mitre.org/data/definitions/276.html)   | 不正なデフォルトパーミッション                                                                                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-295](https://cwe.mitre.org/data/definitions/295.html)   | 不正な証明書の検証                                                                                        | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-297](https://cwe.mitre.org/data/definitions/297.html)   | ホストの不一致による証明書の不適切な検証                                                                  | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-306](https://cwe.mitre.org/data/definitions/306.html)   | 重要な機能の認証の欠落                                                                           | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-311](https://cwe.mitre.org/data/definitions/311.html)   | 機密情報の暗号化の欠落                                                                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-319](https://cwe.mitre.org/data/definitions/319.html)   | 機密情報のクリアテキスト送信                                                                        | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-322](https://cwe.mitre.org/data/definitions/322.html)   | エンティティ認証のないキー交換                                                                             | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-323](https://cwe.mitre.org/data/definitions/323.html)   | 暗号化におけるナンス、キーペアの再利用                                                                                | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-326](https://cwe.mitre.org/data/definitions/326.html)   | 不適切な暗号強度                                                                                         | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-327](https://cwe.mitre.org/data/definitions/327.html)   | 破損または危険な暗号アルゴリズムの使用                                                                       | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-328](https://cwe.mitre.org/data/definitions/328.html)   | 脆弱なハッシュの使用                                                                                                       | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-338](https://cwe.mitre.org/data/definitions/338.html)   | 暗号学的に脆弱な擬似乱数ジェネレーター（PRNG）の使用                                                    | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-346](https://cwe.mitre.org/data/definitions/346.html)   | オリジンの検証エラー                                                                                                | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-347](https://cwe.mitre.org/data/definitions/347.html)   | 暗号署名の不適切な検証                                                                       | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-348](https://cwe.mitre.org/data/definitions/348.html)   | 信頼度の低いソースの使用                                                                                             | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-352](https://cwe.mitre.org/data/definitions/352.html)   | クロスサイトリクエストフォージェリ（CSRF）                                                                                      | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-358](https://cwe.mitre.org/data/definitions/358.html)   | 標準に対する不適切に実装されたセキュリティチェック                                                                     | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-369](https://cwe.mitre.org/data/definitions/369.html)   | ゼロ除算                                                                                                         | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-377](https://cwe.mitre.org/data/definitions/377.html)   | 安全でない一時ファイル                                                                                                | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-401](https://cwe.mitre.org/data/definitions/401.html)   | 有効ライフタイム後のメモリの解放の欠落                                                                     | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-409](https://cwe.mitre.org/data/definitions/409.html)   | 高度に圧縮されたデータの不適切な処理（データ増幅）                                                       | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-416](https://cwe.mitre.org/data/definitions/416.html)   | 解放後の使用                                                                                                         | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-457](https://cwe.mitre.org/data/definitions/457.html)   | 初期化されていない変数の使用                                                                                          | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-470](https://cwe.mitre.org/data/definitions/470.html)   | クラスまたはコードを選択するための外部制御入力の使用（「安全でないリフレクション」）                                     | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-476](https://cwe.mitre.org/data/definitions/476.html)   | NULLポインターの逆参照                                                                                               | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-477](https://cwe.mitre.org/data/definitions/477.html)   | 廃止された関数の使用                                                                                               | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-489](https://cwe.mitre.org/data/definitions/489.html)   | アクティブなデバッグコード                                                                                                      | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-497](https://cwe.mitre.org/data/definitions/497.html)   | 機密情報の不正な制御範囲への公開                                             | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-501](https://cwe.mitre.org/data/definitions/501.html)   | 信頼境界の違反                                                                                               | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-502](https://cwe.mitre.org/data/definitions/502.html)   | 信頼できないデータのデシリアライズ                                                                                      | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-521](https://cwe.mitre.org/data/definitions/521.html)   | 脆弱なパスワード要件                                                                                             | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-522](https://cwe.mitre.org/data/definitions/522.html)   | 不十分に保護された認証情報                                                                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-552](https://cwe.mitre.org/data/definitions/552.html)   | 外部関係者がアクセスできるファイルまたはディレクトリ                                                                    | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-554](https://cwe.mitre.org/data/definitions/554.html)   | ASP.NET設定ミス: 入力の検証フレームワークを使用していません                                                         | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-562](https://cwe.mitre.org/data/definitions/562.html)   | スタック変数のアドレスの返却                                                                                       | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-598](https://cwe.mitre.org/data/definitions/598.html)   | 機密性の高いクエリ文字列を使用したGETリクエストメソッドの使用                                                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-599](https://cwe.mitre.org/data/definitions/599.html)   | OpenSSL証明書の検証の欠落                                                                              | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-601](https://cwe.mitre.org/data/definitions/601.html)   | 信頼できないサイトへのURLリダイレクト（「オープンリダイレクト」）                                                                    | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-606](https://cwe.mitre.org/data/definitions/606.html)   | ループ条件の未チェックの入力                                                                                     | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-611](https://cwe.mitre.org/data/definitions/611.html)   | XML外部エンティティ参照の不適切な制限                                                                  | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-613](https://cwe.mitre.org/data/definitions/613.html)   | 不十分なセッション有効期限                                                                                        | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-614](https://cwe.mitre.org/data/definitions/614.html)   | 'Secure' 属性のないHTTPSセッション内の機密Cookie                                                           | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-639](https://cwe.mitre.org/data/definitions/639.html)   | ユーザー制御キーによる認可のバイパス                                                                       | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-643](https://cwe.mitre.org/data/definitions/643.html)   | XPath式内のデータの不適切な無効化（「XPathインジェクション」）                                           | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-676](https://cwe.mitre.org/data/definitions/676.html)   | 潜在的に危険な関数の使用                                                                                  | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-686](https://cwe.mitre.org/data/definitions/686.html)   | 不正な引数型を使用した関数呼び出し                                                                             | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-704](https://cwe.mitre.org/data/definitions/704.html)   | 不正な型の変換またはキャスト                                                                                      | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-732](https://cwe.mitre.org/data/definitions/732.html)   | 重要なリソースに対する不正なアクセス許可の割り当て                                                                  | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-749](https://cwe.mitre.org/data/definitions/749.html)   | 公開された危険なメソッドまたは関数                                                                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-754](https://cwe.mitre.org/data/definitions/754.html)   | 異常または例外的な状態の不適切なチェック                                                                   | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-757](https://cwe.mitre.org/data/definitions/757.html)   | ネゴシエーション中の安全性の低いアルゴリズムの選択（「アルゴリズムのダウングレード」）                                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-770](https://cwe.mitre.org/data/definitions/770.html)   | 制限またはスロットリングなしのリソースの割り当て                                                                   | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-776](https://cwe.mitre.org/data/definitions/776.html)   | DTDにおける再帰的エンティティ参照の不適切な制限（「XMLエンティティ拡張」）                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-780](https://cwe.mitre.org/data/definitions/780.html)   | OAEPなしのRSAアルゴリズムの使用                                                                                      | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-787](https://cwe.mitre.org/data/definitions/787.html)   | 範囲外書き込み                                                                                                    | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-798](https://cwe.mitre.org/data/definitions/798.html)   | ハードコードされた認証情報の使用                                                                                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-833](https://cwe.mitre.org/data/definitions/833.html)   | デッドロック                                                                                                               | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-843](https://cwe.mitre.org/data/definitions/843.html)   | 互換性のない型を使用したリソースへのアクセス（「型の混乱」）                                                          | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-913](https://cwe.mitre.org/data/definitions/913.html)   | 動的に管理されるコードリソースの不適切な制御                                                                 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-915](https://cwe.mitre.org/data/definitions/915.html)   | 動的に決定されたオブジェクト属性の不適切に制御された変更                                         | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-917](https://cwe.mitre.org/data/definitions/917.html)   | 式言語ステートメントで使用される特殊要素の不適切な無効化（「式言語インジェクション」） | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-918](https://cwe.mitre.org/data/definitions/918.html)   | サーバーサイドアリクエストフォージェリ（SSRF）                                                                                     | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-942](https://cwe.mitre.org/data/definitions/942.html)   | 信頼できないドメインを持つ寛容なクロスドメインポリシー                                                                  | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-943](https://cwe.mitre.org/data/definitions/943.html)   | データクエリロジックにおける特殊要素の不適切な無効化                                                        | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1004](https://cwe.mitre.org/data/definitions/1004.html) | 'HttpOnly'フラグのない機密Cookie                                                                               | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-1021](https://cwe.mitre.org/data/definitions/1021.html) | レンダリングされたUIレイヤーまたはフレームの不適切な制限                                                                   | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1104](https://cwe.mitre.org/data/definitions/1104.html) | メンテナンスされていないサードパーティコンポーネントの使用                                                                             | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1204](https://cwe.mitre.org/data/definitions/1204.html) | 脆弱な初期化ベクター（IV）の生成                                                                          | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1275](https://cwe.mitre.org/data/definitions/1275.html) | 不適切なSameSite属性を持つ機密Cookie                                                                      | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1321](https://cwe.mitre.org/data/definitions/1321.html) | オブジェクトプロトタイプの属性の不適切に制御された変更（「プロトタイプ汚染」）                              | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1327](https://cwe.mitre.org/data/definitions/1327.html) | 制限されていないIPアドレスへのバインド                                                                                  | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1333](https://cwe.mitre.org/data/definitions/1333.html) | 非効率な正規表現の複雑さ                                                                              | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="check-circle" >}}対応 |
| [CWE-1336](https://cwe.mitre.org/data/definitions/1336.html) | テンプレートエンジンで使用される特殊要素の不適切なニュートラル化                                                  | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 |
| [CWE-1390](https://cwe.mitre.org/data/definitions/1390.html) | 脆弱な認証                                                                                                    | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="dotted-circle" >}}非対応 | {{< icon name="check-circle" >}}対応 | {{< icon name="dotted-circle" >}}非対応 |

{{< alert type="note" >}}

このページはお客様の質問に答えられましたか？そうでない場合は、[エピック15343](https://gitlab.com/groups/gitlab-org/-/epics/15343)にコメントして、ユースケースを共有してください。

{{< /alert >}}
