/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import generic.util.FileChannelLock;
import generic.util.FileLocker;
import java.io.File;

public class ChannelLocker
extends FileLocker {
    private static final String CHANNEL_LOCK_TYPE = "Channel Lock";
    private FileChannelLock channelLock;

    ChannelLocker(File lockFile) {
        super(lockFile);
    }

    @Override
    protected String getLockType() {
        return CHANNEL_LOCK_TYPE;
    }

    @Override
    public boolean lock() {
        if (this.canLock()) {
            return this.createLockFile();
        }
        return false;
    }

    private boolean canLock() {
        if (this.existingLockType == null) {
            return true;
        }
        return this.canChannelLock();
    }

    private boolean canChannelLock() {
        if (!CHANNEL_LOCK_TYPE.equals(this.existingLockType)) {
            return false;
        }
        return this.isChannelLockAvailable();
    }

    private boolean isChannelLockAvailable() {
        FileChannelLock testChannelLock = new FileChannelLock(this.lockFile);
        boolean didLock = testChannelLock.lock();
        testChannelLock.release();
        return didLock;
    }

    @Override
    protected boolean createLockFile() {
        if (!super.createLockFile()) {
            return false;
        }
        this.channelLock = new FileChannelLock(this.lockFile);
        this.isLocked = this.channelLock.lock();
        return this.isLocked;
    }

    @Override
    public void release() {
        if (this.channelLock != null) {
            this.channelLock.release();
        }
        super.release();
    }
}

