/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.numberformat.BoundedRangeDecimalFormatterFactory;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.SingleValueColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DoubleValueConstraintEditor
extends AbstractColumnConstraintEditor<Double> {
    public static final String FLOATING_POINT_FORMAT = "0.##########;-0.##########";
    private JSpinner spinner;
    private SpinnerNumberModel spinnerModel;
    private String errorMessage;

    public DoubleValueConstraintEditor(ColumnConstraint<Double> constraint) {
        super(constraint);
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        Double value = (double)this.getConstraint().getConstraintValue();
        Double stepSize = 0.1;
        this.spinnerModel = new SpinnerNumberModel(value, null, null, stepSize);
        this.spinner = new JSpinner(this.spinnerModel);
        this.spinner.setName("double.spinner");
        JSpinner.NumberEditor numEditor = (JSpinner.NumberEditor)this.spinner.getEditor();
        final JFormattedTextField textField = numEditor.getTextField();
        textField.setHorizontalAlignment(4);
        textField.setValue(value);
        textField.setFormatterFactory(new BoundedRangeDecimalFormatterFactory(FLOATING_POINT_FORMAT));
        textField.setColumns(12);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DoubleValueConstraintEditor.this.textChanged(textField);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DoubleValueConstraintEditor.this.textChanged(textField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DoubleValueConstraintEditor.this.textChanged(textField);
            }
        });
        this.spinner.addMouseWheelListener(e -> {
            Number val = (Number)this.spinner.getValue();
            try {
                double step = this.spinnerModel.getStepSize().doubleValue();
                if (e.getWheelRotation() > 0) {
                    this.spinner.setValue(this.decrement(val, step));
                } else {
                    this.spinner.setValue(this.increment(val, step));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        this.spinnerModel.addChangeListener(e -> this.valueChanged());
        panel.add(this.spinner);
        return panel;
    }

    private void textChanged(JTextField textField) {
        SystemUtilities.runSwingLater(() -> {
            try {
                int caretPosition = textField.getCaretPosition();
                int length = textField.getText().length();
                int fromEnd = length - caretPosition;
                this.spinner.commitEdit();
                length = textField.getText().length();
                textField.setCaretPosition(Math.max(length - fromEnd, 0));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.valueChanged();
        });
    }

    private Number increment(Number base, Number by) {
        if (base instanceof Byte || base instanceof Short || base instanceof Integer || base instanceof Long) {
            return base.longValue() + by.longValue();
        }
        return base.doubleValue() + by.doubleValue();
    }

    private Number decrement(Number base, Number by) {
        if (base instanceof Byte || base instanceof Short || base instanceof Integer || base instanceof Long) {
            return base.longValue() - by.longValue();
        }
        return base.doubleValue() - by.doubleValue();
    }

    @Override
    protected ColumnConstraint<Double> getValueFromComponent() {
        double v = (Double)this.spinnerModel.getValue();
        return this.getConstraint().copy(v);
    }

    @Override
    protected void updateEditorComponent() {
        double constraintValue = this.getConstraint().getConstraintValue();
        this.spinner.setValue(constraintValue);
    }

    @Override
    public void reset() {
        this.setValue(this.getConstraint().copy(0.0));
    }

    @Override
    protected boolean checkEditorValueValidity() {
        boolean valid = this.checkEditorValue();
        return valid;
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        this.spinner.getEditor().setBackground(isValid ? VALID_INPUT_COLOR : INVALID_INPUT_COLOR);
    }

    private boolean checkEditorValue() {
        JSpinner.NumberEditor numEditor = (JSpinner.NumberEditor)this.spinner.getEditor();
        JFormattedTextField textField = numEditor.getTextField();
        JFormattedTextField.AbstractFormatter formatter = textField.getFormatter();
        String text = textField.getText();
        try {
            Double valueFromTextField = (Double)formatter.stringToValue(text);
            Double spinnerValue = (Double)this.spinner.getValue();
            String valueFromField = formatter.valueToString(valueFromTextField);
            String valueFromSpinner = formatter.valueToString(spinnerValue);
            if (valueFromField.equals(valueFromSpinner)) {
                this.errorMessage = "";
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.errorMessage = "Invalid Value!";
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private SingleValueColumnConstraint<Double> getConstraint() {
        return (SingleValueColumnConstraint)this.currentConstraint;
    }

    JSpinner getSpinner() {
        return this.spinner;
    }
}

