/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class UserOpSymbol
extends SleighSymbol {
    private int index;

    public UserOpSymbol(Location location) {
        super(location);
    }

    public UserOpSymbol(Location location, String nm) {
        super(location, nm);
        this.index = 0;
    }

    public void setIndex(int ind) {
        this.index = ind;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.userop_symbol;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_USEROP);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_INDEX, this.index);
        encoder.closeElement(SlaFormat.ELEM_USEROP);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_USEROP_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_USEROP_HEAD);
    }
}

