/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.SAXException;
import utilities.util.FileUtilities;

public class PdbUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PdbIdentifiers getPdbIdentifiers(File file, TaskMonitor monitor) {
        String extension;
        switch (extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase()) {
            case "pdb": {
                PdbIdentifiers pdbIdentifiers;
                AbstractPdb pdb = PdbParser.parse(file, new PdbReaderOptions(), monitor);
                try {
                    PdbIdentifiers identifiers;
                    pdbIdentifiers = identifiers = pdb.getIdentifiers();
                    if (pdb == null) return pdbIdentifiers;
                }
                catch (Throwable identifiers) {
                    try {
                        if (pdb == null) throw identifiers;
                        try {
                            pdb.close();
                            throw identifiers;
                        }
                        catch (Throwable throwable) {
                            identifiers.addSuppressed(throwable);
                        }
                        throw identifiers;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                pdb.close();
                return pdbIdentifiers;
            }
            case "xml": {
                XmlPullParser parser = null;
                try {
                    parser = XmlPullParserFactory.create((File)file, null, (boolean)false);
                    XmlElement xmlelem = parser.peek();
                    if (!"pdb".equals(xmlelem.getName())) {
                        PdbIdentifiers pdbIdentifiers = null;
                        return pdbIdentifiers;
                    }
                    String guidStr = xmlelem.getAttribute("guid");
                    GUID guid = new GUID(guidStr);
                    int age = Integer.parseInt(xmlelem.getAttribute("age"));
                    PdbIdentifiers pdbIdentifiers = new PdbIdentifiers(0, 0, age, guid, null);
                    return pdbIdentifiers;
                }
                catch (IOException | RuntimeException | SAXException e) {
                    PdbIdentifiers pdbIdentifiers = null;
                    return pdbIdentifiers;
                }
                finally {
                    if (parser != null) {
                        parser.dispose();
                    }
                }
            }
        }
        return null;
    }

    public static String extractSingletonCabToFile(File cabFile, File destFile, TaskMonitor monitor) throws CancelledException, IOException {
        block12: {
            FileSystemService fsService = FileSystemService.getInstance();
            FSRL cabFSRL = fsService.getLocalFSRL(cabFile);
            try (GFileSystem fs = fsService.openFileSystemContainer(cabFSRL, monitor);){
                String string;
                block13: {
                    List rootListing;
                    if (fs == null || (rootListing = fs.getListing(null)).size() != 1) break block12;
                    GFile f = (GFile)rootListing.get(0);
                    InputStream is = fs.getInputStream(f, monitor);
                    try {
                        FileUtilities.copyStreamToFile((InputStream)is, (File)destFile, (boolean)false, (TaskMonitor)monitor);
                        string = f.getName();
                        if (is == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return string;
            }
        }
        throw new IOException("Unable to find file to extract");
    }
}

