/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.SubstringListMsType;
import ghidra.util.Msg;

public class StringIdMsType
extends AbstractMsType {
    public static final int PDB_ID = 5637;
    private RecordNumber substringIdListRecordNumber;
    private String name;

    public StringIdMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.substringIdListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.ITEM, 32);
        this.name = reader.parseString(pdb, StringParseType.StringNt);
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5637;
    }

    public String getString() {
        StringBuilder builder = new StringBuilder();
        this.buildString(builder);
        return builder.toString();
    }

    public String getStringPortion() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        this.buildString(builder);
    }

    private void buildString(StringBuilder builder) {
        if (this.substringIdListRecordNumber != RecordNumber.NO_TYPE) {
            AbstractMsType subStringList = this.pdb.getTypeRecord(this.substringIdListRecordNumber);
            if (!(subStringList instanceof SubstringListMsType)) {
                String message = "Expected SubstringListMsType, but found " + subStringList.getClass().getSimpleName();
                Msg.info((Object)this, (Object)message);
                PdbLog.message(message);
                return;
            }
            builder.append(subStringList);
        }
        builder.append(this.name);
    }
}

