/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomSubspace
implements StructConverter {
    public static final int SIZE = 40;
    private int spaceIndex;
    private int accessControlBits;
    private boolean memoryResident;
    private boolean dupCommon;
    private boolean isCommon;
    private boolean isLoadable;
    private int quadrant;
    private boolean initiallyFrozen;
    private boolean isFirst;
    private boolean codeOnly;
    private int sortKey;
    private boolean replicateInit;
    private boolean continuation;
    private boolean isThreadSpecific;
    private boolean isComdat;
    private int reserved;
    private int fileLocInitValue;
    private long initializationLength;
    private long subspaceStart;
    private long subspaceLength;
    private int reserved2;
    private int alignment;
    private String name;
    private int fixupRequestIndex;
    private long fixupRequestQuantity;

    public SomSubspace(BinaryReader reader, long spaceStringsLocation) throws IOException {
        this.spaceIndex = reader.readNextInt();
        int bitfield = reader.readNextInt();
        this.reserved = bitfield & 0xF;
        this.isComdat = (bitfield >> 4 & 1) != 0;
        this.isThreadSpecific = (bitfield >> 5 & 1) != 0;
        this.continuation = (bitfield >> 6 & 1) != 0;
        this.replicateInit = (bitfield >> 7 & 1) != 0;
        this.sortKey = bitfield >> 8 & 0xFF;
        this.codeOnly = (bitfield >> 16 & 1) != 0;
        this.isFirst = (bitfield >> 17 & 1) != 0;
        this.initiallyFrozen = (bitfield >> 18 & 1) != 0;
        this.quadrant = bitfield >> 19 & 3;
        this.isLoadable = (bitfield >> 21 & 1) != 0;
        this.isCommon = (bitfield >> 22 & 1) != 0;
        this.dupCommon = (bitfield >> 23 & 1) != 0;
        this.memoryResident = (bitfield >> 24 & 1) != 0;
        this.accessControlBits = bitfield >> 25 & 0x7F;
        this.fileLocInitValue = reader.readNextInt();
        this.initializationLength = reader.readNextUnsignedInt();
        this.subspaceStart = reader.readNextUnsignedInt();
        this.subspaceLength = reader.readNextUnsignedInt();
        bitfield = reader.readNextInt();
        this.alignment = bitfield & 0x7FFFFFF;
        this.reserved2 = bitfield >> 27 & 0x1F;
        this.name = reader.readAsciiString(spaceStringsLocation + reader.readNextUnsignedInt());
        this.fixupRequestIndex = reader.readNextInt();
        this.fixupRequestQuantity = reader.readNextUnsignedInt();
    }

    public int getSpaceIndex() {
        return this.spaceIndex;
    }

    public int getAccessControlBits() {
        return this.accessControlBits;
    }

    public boolean isMemoryResident() {
        return this.memoryResident;
    }

    public boolean isDupCommon() {
        return this.dupCommon;
    }

    public boolean isCommon() {
        return this.isCommon;
    }

    public boolean isLoadable() {
        return this.isLoadable;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public boolean isInitiallyFrozen() {
        return this.initiallyFrozen;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isCodeOnly() {
        return this.codeOnly;
    }

    public int getSortKey() {
        return this.sortKey;
    }

    public boolean isReplicateInit() {
        return this.replicateInit;
    }

    public boolean isContinuation() {
        return this.continuation;
    }

    public boolean isThreadSpecific() {
        return this.isThreadSpecific;
    }

    public boolean isComdat() {
        return this.isComdat;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getFileLocInitValue() {
        return this.fileLocInitValue;
    }

    public long getInitializationLength() {
        return this.initializationLength;
    }

    public long getSubspaceStart() {
        return this.subspaceStart;
    }

    public long getSubspaceLength() {
        return this.subspaceLength;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getName() {
        return this.name;
    }

    public int getFixupRequestIndex() {
        return this.fixupRequestIndex;
    }

    public long getFixupRequestQuantity() {
        return this.fixupRequestQuantity;
    }

    public boolean isRead() {
        return this.getAccessControlType() < 4;
    }

    public boolean isWrite() {
        return this.getAccessControlType() == 1 || this.getAccessControlType() == 3;
    }

    public boolean isExecute() {
        return this.getAccessControlType() >= 2;
    }

    private int getAccessControlType() {
        return this.accessControlBits >> 4 & 3;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("subspace_dictionary_record", 40);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "space_index", "");
        try {
            struct.addBitField(DWORD, 7, "access_control_bits", "access for PDIR entries");
            struct.addBitField(DWORD, 1, "memory_resident", "lock in memory during execution");
            struct.addBitField(DWORD, 1, "dup_common", "data name clashes allowed");
            struct.addBitField(DWORD, 1, "is_common", "subspace is a common");
            struct.addBitField(DWORD, 1, "is_loadable", "");
            struct.addBitField(DWORD, 2, "quadrant", "quadrant request");
            struct.addBitField(DWORD, 1, "initially_frozen", "must be locked into memory when OS is booted");
            struct.addBitField(DWORD, 1, "is_first", "must be first subspace");
            struct.addBitField(DWORD, 1, "code_only", "must contain only code");
            struct.addBitField(DWORD, 8, "sort_key", "subspace sort key");
            struct.addBitField(DWORD, 1, "replicate_init", "init values replicated to fill subspace_length");
            struct.addBitField(DWORD, 1, "continuation", "subspace is a continuation");
            struct.addBitField(DWORD, 1, "is_tspecific", "is thread specific?");
            struct.addBitField(DWORD, 1, "is_comdat", "Is for COMDAT subspaces?");
            struct.addBitField(DWORD, 4, "reserved", "");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(DWORD, "file_loc_init_value", "file location or initialization value");
        struct.add(DWORD, "initialization_length", "");
        struct.add(DWORD, "subspace_start", "starting offset");
        struct.add(DWORD, "subspace_length", "number of bytes defined by this subspace");
        try {
            struct.addBitField(DWORD, 5, "reserved2", "");
            struct.addBitField(DWORD, 27, "alignment", "alignment required for the subspace (largest alignment requested for any item in the subspace)");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(DWORD, "name", "index of subspace name");
        struct.add(DWORD, "fixup_request_index", "index into fixup array");
        struct.add(DWORD, "fixup_request_quantity", "number of fixup requests");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

