/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.som.SomAuxHeader;
import ghidra.app.util.bin.format.som.SomSysClock;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomLinkerFootprintAuxHeader
extends SomAuxHeader {
    private String productId;
    private String versionId;
    private SomSysClock htime;

    public SomLinkerFootprintAuxHeader(BinaryReader reader) throws IOException {
        super(reader);
        this.productId = reader.readNextAsciiString(12);
        this.versionId = reader.readNextAsciiString(12);
        this.htime = new SomSysClock(reader);
    }

    public String getProductId() {
        return this.productId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public SomSysClock getHtime() {
        return this.htime;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("linker_footprint", 0);
        struct.setPackingEnabled(true);
        struct.add(this.auxId.toDataType(), "som_auxhdr", null);
        struct.add(STRING, 12, "product_id", null);
        struct.add(STRING, 8, "version_id", null);
        struct.add(this.htime.toDataType(), "htime", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

