/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomDynamicRelocation
implements StructConverter {
    public static final int SIZE = 20;
    private int shlib;
    private int symbol;
    private int location;
    private int value;
    private int type;
    private byte reserved;
    private short moduleIndex;

    public SomDynamicRelocation(BinaryReader reader) throws IOException {
        this.shlib = reader.readNextInt();
        this.symbol = reader.readNextInt();
        this.location = reader.readNextInt();
        this.value = reader.readNextInt();
        this.type = reader.readNextUnsignedByte();
        this.reserved = reader.readNextByte();
        this.moduleIndex = reader.readNextShort();
    }

    public int getShlib() {
        return this.shlib;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public int getLocation() {
        return this.location;
    }

    public int getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public short getModuleIndex() {
        return this.moduleIndex;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dreloc_record", 20);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "shlib", "reserved");
        struct.add(DWORD, "symbol", "index into import table of shlib if *_EXT type. low order 16 bits used for module index if *_INT type");
        struct.add(DWORD, "location", "offset of location to patch data-relative");
        struct.add(DWORD, "value", "text or data-relative offset to use for patch if internal-type fixup");
        struct.add(BYTE, "type", "type of dreloc record");
        struct.add(BYTE, "reserved", "currently unused");
        struct.add(WORD, "module_index", "reserved");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

