/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexHasSemantics;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableMethodSemantics
extends CliAbstractTable {
    public CliTableMethodSemantics(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliMethodSemanticsRow(reader.readNextShort(), this.readTableIndex(reader, CliTypeTable.MethodDef), CliIndexHasSemantics.readCodedIndex(reader, stream)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "MethodSemantics Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumMethodSemanticsAttributes.dataType, "Semantics", "Bitmask of type MethodSemanticsAttributes");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.MethodDef), "Method", "index into MethodDef table");
        rowDt.add(CliIndexHasSemantics.toDataType(this.metadataStream), "Association", "HasSemantics coded index into Event or Property");
        return rowDt;
    }

    public class CliMethodSemanticsRow
    extends CliAbstractTableRow {
        public short semantics;
        public int methodIndex;
        public int associationIndex;

        public CliMethodSemanticsRow(short semantics, int methodIndex, int associationIndex) {
            this.semantics = semantics;
            this.methodIndex = methodIndex;
            this.associationIndex = associationIndex;
        }

        @Override
        public String getRepresentation() {
            String assocRep;
            try {
                assocRep = CliTableMethodSemantics.this.getRowRepresentationSafe(CliIndexHasSemantics.getTableName(this.associationIndex), CliIndexHasSemantics.getRowIndex(this.associationIndex));
            }
            catch (InvalidInputException e) {
                assocRep = Integer.toHexString(this.associationIndex);
            }
            return String.format("Method %s Association %s Semantics %s", CliTableMethodSemantics.this.getRowRepresentationSafe(CliTypeTable.MethodDef, this.methodIndex), assocRep, CliFlags.CliEnumMethodSemanticsAttributes.dataType.getName(this.semantics & 0xFFFF));
        }
    }
}

