/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.MemoryByteIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public abstract class BasicChecksumAlgorithm
extends ChecksumAlgorithm {
    private SupportedByteSize size;
    private int numBytes;

    public BasicChecksumAlgorithm(SupportedByteSize size) {
        super("Checksum-" + size.getNumBytes() * 8);
        this.size = size;
        this.numBytes = size.getNumBytes();
    }

    @Override
    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, ComputeChecksumsProvider provider) throws MemoryAccessException, CancelledException {
        if (provider == null) {
            this.updateChecksum(memory, addrSet, monitor, false, false, false, false);
        } else {
            this.updateChecksum(memory, addrSet, monitor, provider.isXor(), provider.isCarry(), provider.isOnes(), provider.isTwos());
        }
    }

    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, boolean xor, boolean carry, boolean onesComp, boolean twosComp) throws MemoryAccessException, CancelledException {
        long sum = 0L;
        int i = 0;
        MemoryByteIterator bytes = new MemoryByteIterator(memory, addrSet);
        while (bytes.hasNext()) {
            long next;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            long b = bytes.next() & 0xFF;
            long l = next = this.size == SupportedByteSize.CHECKSUM8 ? b : b << (this.numBytes - 1 - i % this.numBytes) * 8;
            sum = xor ? (sum ^= next) : (sum += next);
            ++i;
        }
        if (carry) {
            long max = (long)Math.pow(2.0, this.numBytes * 8);
            while (sum >= max) {
                sum = (sum & max - 1L) + (sum >> this.numBytes * 8);
            }
        }
        if (onesComp) {
            sum ^= 0xFFFFFFFFFFFFFFFFL;
        } else if (twosComp) {
            sum = -sum;
        }
        this.checksum = BasicChecksumAlgorithm.toArray(sum, this.numBytes);
    }

    @Override
    public boolean supportsDecimal() {
        return true;
    }

    public static enum SupportedByteSize {
        CHECKSUM8(1),
        CHECKSUM16(2),
        CHECKSUM32(4);

        private int numBytes;

        private SupportedByteSize(int numBytes) {
            this.numBytes = numBytes;
        }

        public int getNumBytes() {
            return this.numBytes;
        }
    }
}

