/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.RustNamespace;
import ghidra.app.plugin.core.analysis.rust.demangler.RustString;
import ghidra.app.plugin.core.analysis.rust.demangler.Symbol;
import ghidra.app.plugin.core.analysis.rust.demangler.SymbolNode;
import java.net.IDN;

class RustIdentifier
implements SymbolNode {
    String id;
    RustNamespace namespace;
    RustString disambiguator;

    public RustIdentifier(RustNamespace namespace, String id, RustString disambiguator) {
        this.id = id;
        this.namespace = namespace;
        this.disambiguator = disambiguator;
    }

    public static RustIdentifier parse(Symbol s, RustNamespace namespace) {
        RustString disambiguator = null;
        if (s.nextChar() == 's') {
            disambiguator = RustIdentifier.parseDisambiguator(s);
        }
        String id = RustIdentifier.parseUndisambiguatedIdentifier(s);
        return new RustIdentifier(namespace, id, disambiguator);
    }

    public static RustString parseDisambiguator(Symbol s) {
        char c = s.popChar();
        assert (c == 's');
        return new RustString(s.parseBase62Number());
    }

    public static String parseUndisambiguatedIdentifier(Symbol s) {
        boolean punycode = s.stripPrefix('u');
        int num = s.parseDigits();
        if (s.nextChar() == '_') {
            s.popChar();
        }
        if (num == 0) {
            char c = s.popChar();
            return "{closure#" + c + "}";
        }
        String bytes = s.parseString(num);
        if (punycode) {
            return IDN.toASCII(bytes, 1);
        }
        return bytes;
    }

    public String toString() {
        return this.id.toString();
    }
}

