/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.file.formats.bplist.BinaryPropertyListUtil;
import ghidra.file.formats.bplist.NSObject;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public class NSSet
extends NSObject {
    private boolean ordered;
    private int objectRefSize;
    private Set<Integer> set;

    public NSSet(boolean ordered, int objectRefSize) {
        this.ordered = ordered;
        this.objectRefSize = objectRefSize;
        this.set = ordered ? new TreeSet<Integer>() : new LinkedHashSet<Integer>();
    }

    @Override
    public String getType() {
        return "NSSet";
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Set<Integer> getSet() {
        return this.set;
    }

    public void add(int object) {
        this.set.add(object);
    }

    @Override
    public void markup(Data objectData, Program program, TaskMonitor monitor) throws CancelledException {
        ReferenceManager referenceManager = program.getReferenceManager();
        for (int i = 0; i < objectData.getNumComponents(); ++i) {
            long value;
            String name;
            Symbol symbol;
            monitor.checkCancelled();
            Data component = objectData.getComponent(i);
            if (!component.getFieldName().startsWith("value") || (symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)(name = BinaryPropertyListUtil.generateName(value = this.getValue(component))), err -> Msg.error((Object)this, (Object)err))) == null) continue;
            referenceManager.addMemoryReference(component.getMinAddress(), symbol.getAddress(), RefType.DATA, SourceType.ANALYSIS, 0);
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("NSSet_" + this.set.size(), 0);
        this.addHeader((Structure)structure, this.set.size());
        for (int i = 0; i < this.set.size(); ++i) {
            if (this.objectRefSize == 1) {
                structure.add(BYTE, "value_" + i, null);
                continue;
            }
            if (this.objectRefSize == 2) {
                structure.add(WORD, "value_" + i, null);
                continue;
            }
            if (this.objectRefSize == 4) {
                structure.add(DWORD, "value_" + i, null);
                continue;
            }
            if (this.objectRefSize == 8) {
                structure.add(QWORD, "value_" + i, null);
                continue;
            }
            throw new RuntimeException();
        }
        return structure;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Integer object : this.set) {
            builder.append(" ");
            builder.append("0x" + Integer.toHexString(object));
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(" ");
        builder.append("}");
        return builder.toString();
    }
}

