/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.TransactionMetadata;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tmv!B\u00193\u0011\u0003Id!B\u001e3\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005bB#\u0002\u0005\u0004%IA\u0012\u0005\u0007\u001f\u0006\u0001\u000b\u0011B$\t\u000fA\u000b!\u0019!C\u0005\r\"1\u0011+\u0001Q\u0001\n\u001dC\u0001BU\u0001C\u0002\u0013\u0005!g\u0015\u0005\u00079\u0006\u0001\u000b\u0011\u0002+\t\u000bu\u000bA\u0011\u00010\u0007\tm\u0012\u0004\u0001\u0019\u0005\ti*\u0011\t\u0011)A\u0005k\"A!P\u0003B\u0001B\u0003%1\u0010\u0003\u0006\u0002\u0004)\u0011\t\u0011)A\u0005\u0003\u000bA!\"!\u0005\u000b\u0005\u0003\u0005\u000b\u0011BA\n\u0011)\tIB\u0003B\u0001B\u0003%\u00111\u0004\u0005\u0007\u0007*!\t!!\u000b\t\u0011\u0005U\"B1A\u0005\n\u0019Cq!a\u000e\u000bA\u0003%q\t\u0003\u0005\u0002:)\u0011\r\u0011\"\u0003G\u0011\u001d\tYD\u0003Q\u0001\n\u001dC\u0011\"!\u0010\u000b\u0005\u0004%I!a\u0010\t\u0011\u00055#\u0002)A\u0005\u0003\u0003B\u0011\"a\u0014\u000b\u0005\u0004%I!!\u0015\t\u0011\u0005}#\u0002)A\u0005\u0003'B\u0011\"!\u0019\u000b\u0005\u0004%I!a\u0019\t\u0011\u0005u$\u0002)A\u0005\u0003KB\u0011\"a \u000b\u0005\u0004%I!!!\t\u0011\u0005\r%\u0002)A\u0005\u0003oB\u0011\"!\"\u000b\u0005\u0004%I!a\"\t\u0011\u0005m%\u0002)A\u0005\u0003\u0013C\u0011\"!(\u000b\u0005\u0004%I!a(\t\u0011\u0005m&\u0002)A\u0005\u0003CCq!!0\u000b\t\u0003\ny\fC\u0004\u0002H*!I!a0\t\u0011\u0005%'\u0002\"\u00013\u0003\u0017D\u0001\"a6\u000b\t\u0003\u0011\u0014\u0011\u0011\u0005\t\u00033TA\u0011\u0001\u001a\u0002\\\"9\u0011q\u001f\u0006\u0005\n\u0005}\u0006bBA}\u0015\u0011\u0005\u00131 \u0005\b\u0005\u0017QA\u0011\u0002B\u0007\u0011\u001d\u0011\u0019B\u0003C\u0001\u0005+AqA!\u0012\u000b\t\u0003\u00119\u0005C\u0004\u0003J)!IAa\u0013\t\u000f\tU#\u0002\"\u0001\u0003X!9!Q\f\u0006\u0005\n\t}\u0003b\u0002B3\u0015\u0011\u0005!q\r\u0005\b\u0005\u001fSA\u0011\u0001BI\u0011\u001d\u00119J\u0003C\u0001\u00053\u000bq\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0015\t\u0019D'A\u0006ue\u0006t7/Y2uS>t'BA\u001b7\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003]\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002;\u00035\t!GA\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u001c\"!A\u001f\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011(A\u0013V].twn\u001e8EKN$\u0018N\\1uS>t\u0017+^3vKNK'0Z'fiJL7MT1nKV\tq\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A.\u00198h\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\rM#(/\u001b8h\u0003\u0019*fn\u001b8po:$Um\u001d;j]\u0006$\u0018n\u001c8Rk\u0016,XmU5{K6+GO]5d\u001d\u0006lW\rI\u0001\"\u0019><\u0017\t\u001d9f]\u0012\u0014V\r\u001e:z#V,W/Z*ju\u0016lU\r\u001e:jG:\u000bW.Z\u0001#\u0019><\u0017\t\u001d9f]\u0012\u0014V\r\u001e:z#V,W/Z*ju\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u00175+GO]5d\u001d\u0006lWm]\u000b\u0002)B\u0019QKW$\u000e\u0003YS!a\u0016-\u0002\u0013%lW.\u001e;bE2,'BA-@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00037Z\u00131aU3u\u00031iU\r\u001e:jG:\u000bW.Z:!\u0003\u0015\t\u0007\u000f\u001d7z)5y&Q\u0014BP\u0005W\u0013iKa,\u00032B\u0011!HC\n\u0004\u0015\u0005t\u0007C\u00012m\u001b\u0005\u0019'B\u00013f\u0003\u0011)H/\u001b7\u000b\u0005\u0019<\u0017AB:feZ,'O\u0003\u00028Q*\u0011\u0011N[\u0001\u0007CB\f7\r[3\u000b\u0003-\f1a\u001c:h\u0013\ti7MA\u000bJ]R,'O\u0011:pW\u0016\u00148+\u001a8e)\"\u0014X-\u00193\u0011\u0005=\u0014X\"\u00019\u000b\u0005E4\u0014!B;uS2\u001c\u0018BA:q\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007C\u0001<y\u001b\u00059(B\u000147\u0013\tIxOA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fO\u0006AQ.\u001a;bI\u0006$\u0018-C\u0002\u0002\u0002u\u0014Q\"T3uC\u0012\fG/Y\"bG\",\u0017!\u00048fi^|'o[\"mS\u0016tG\u000f\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYaZ\u0001\bG2LWM\u001c;t\u0013\u0011\ty!!\u0003\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u0003=!\bP\\*uCR,W*\u00198bO\u0016\u0014\bc\u0001\u001e\u0002\u0016%\u0019\u0011q\u0003\u001a\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004B!!\b\u0002&5\u0011\u0011q\u0004\u0006\u0004c\u0006\u0005\"bAA\u0012O\u000611m\\7n_:LA!a\n\u0002 \t!A+[7f)-y\u00161FA\u0017\u0003_\t\t$a\r\t\u000bQ\u0004\u0002\u0019A;\t\u000bi\u0004\u0002\u0019A>\t\u000f\u0005\r\u0001\u00031\u0001\u0002\u0006!9\u0011\u0011\u0003\tA\u0002\u0005M\u0001bBA\r!\u0001\u0007\u00111D\u0001\u000f[\u0016$(/[2t!\u0006\u001c7.Y4f\u0003=iW\r\u001e:jGN\u0004\u0016mY6bO\u0016\u0004\u0013\u0001E7fiJL7m]\"mCN\u001ch*Y7f\u0003EiW\r\u001e:jGN\u001cE.Y:t\u001d\u0006lW\rI\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f*\u0017aB7fiJL7m]\u0005\u0005\u0003\u0017\n)EA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013aF5oi\u0016\u0014(I]8lKJd\u0015n\u001d;f]\u0016\u0014h*Y7f+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\u0011\tI&!\t\u0002\u000f9,Go^8sW&!\u0011QLA,\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003aIg\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW\rI\u0001\u0016[\u0006\u00148.\u001a:t#V,W/\u001a)fe\n\u0013xn[3s+\t\t)\u0007\u0005\u0005\u0002h\u00055\u0014\u0011OA<\u001b\t\tIGC\u0002\u0002la\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\ty'!\u001b\u0003\u00075\u000b\u0007\u000fE\u0002?\u0003gJ1!!\u001e@\u0005\rIe\u000e\u001e\t\u0004u\u0005e\u0014bAA>e\tqA\u000b\u001f8NCJ\\WM])vKV,\u0017AF7be.,'o])vKV,\u0007+\u001a:Ce>\\WM\u001d\u0011\u000295\f'o[3sgF+X-^3G_J,fn\u001b8po:\u0014%o\\6feV\u0011\u0011qO\u0001\u001e[\u0006\u00148.\u001a:t#V,W/\u001a$peVs7N\\8x]\n\u0013xn[3sA\u00051B\u000f\u001f8M_\u001e\f\u0005\u000f]3oIJ+GO]=Rk\u0016,X-\u0006\u0002\u0002\nB1\u00111RAI\u0003+k!!!$\u000b\t\u0005-\u0014q\u0012\u0006\u0003I.KA!a%\u0002\u000e\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB\u0019!(a&\n\u0007\u0005e%G\u0001\nQK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017a\u0006;y]2{w-\u00119qK:$'+\u001a;ssF+X-^3!\u0003y!(/\u00198tC\u000e$\u0018n\u001c8t/&$\b\u000eU3oI&tw-T1sW\u0016\u00148/\u0006\u0002\u0002\"BA\u00111RAR\u0003O\u000b)*\u0003\u0003\u0002&\u00065%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011\u0011VA\\\u001d\u0011\tY+a-\u0011\u0007\u00055v(\u0004\u0002\u00020*\u0019\u0011\u0011\u0017\u001d\u0002\rq\u0012xn\u001c;?\u0013\r\t)lP\u0001\u0007!J,G-\u001a4\n\u00079\u000bILC\u0002\u00026~\nq\u0004\u001e:b]N\f7\r^5p]N<\u0016\u000e\u001e5QK:$\u0017N\\4NCJ\\WM]:!\u0003!\u0019\b.\u001e;e_^tGCAAa!\rq\u00141Y\u0005\u0004\u0003\u000b|$\u0001B+oSR\fQB]3n_Z,W*\u001a;sS\u000e\u001c\u0018AD9vKV,gi\u001c:Ce>\\WM\u001d\u000b\u0005\u0003\u001b\f\u0019\u000eE\u0003?\u0003\u001f\f9(C\u0002\u0002R~\u0012aa\u00149uS>t\u0007bBAkG\u0001\u0007\u0011\u0011O\u0001\tEJ|7.\u001a:JI\u0006)\u0012/^3vK\u001a{'/\u00168l]><hN\u0011:pW\u0016\u0014\u0018aE1eI6\u000b'o[3sg\u001a{'O\u0011:pW\u0016\u0014H\u0003CAa\u0003;\fI/!<\t\u000f\u0005}W\u00051\u0001\u0002b\u00061!M]8lKJ\u0004B!a9\u0002f6\u0011\u0011\u0011E\u0005\u0005\u0003O\f\tC\u0001\u0003O_\u0012,\u0007bBAvK\u0001\u0007\u0011\u0011O\u0001\u0012ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAxK\u0001\u0007\u0011\u0011_\u0001\u001ca\u0016tG-\u001b8h\u0007>l\u0007\u000f\\3uKRCh.\u00118e\u001b\u0006\u00148.\u001a:\u0011\u0007i\n\u00190C\u0002\u0002vJ\u0012\u0001\u0005U3oI&twmQ8na2,G/\u001a+y]\u0006sG-T1sW\u0016\u0014XI\u001c;ss\u0006y!/\u001a;ss2{w-\u00119qK:$7/\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011Q \t\u0007\u0003\u007f\u0014\tA!\u0002\u000e\u0005\u0005=\u0015\u0002\u0002B\u0002\u0003\u001f\u0013!bQ8mY\u0016\u001cG/[8o!\r\u0011'qA\u0005\u0004\u0005\u0013\u0019'a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/\u0001\nxe&$X\r\u0016=o\u0007>l\u0007\u000f\\3uS>tG\u0003BAa\u0005\u001fAqA!\u0005)\u0001\u0004\t)*\u0001\nqK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017aE1eIRCh.T1sW\u0016\u00148\u000fV8TK:$GCCAa\u0005/\u0011YBa\u000b\u0003<!9!\u0011D\u0015A\u0002\u0005E\u0014\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u001d\u0011i\"\u000ba\u0001\u0005?\t\u0011\u0002\u001e=o%\u0016\u001cX\u000f\u001c;\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQAA!\n\u0002\"\u0005A!/Z9vKN$8/\u0003\u0003\u0003*\t\r\"!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\"9!QF\u0015A\u0002\t=\u0012a\u0003;y]6+G/\u00193bi\u0006\u0004BA!\r\u000385\u0011!1\u0007\u0006\u0004g\tU\"BA\u001bh\u0013\u0011\u0011IDa\r\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\tu\u0012\u00061\u0001\u0003@\u0005Ya.Z<NKR\fG-\u0019;b!\u0011\u0011\tD!\u0011\n\t\t\r#1\u0007\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018-A\rok6$\u0006P\\:XSRD\u0007+\u001a8eS:<W*\u0019:lKJ\u001cXCAA9\u0003aA\u0017m\u001d)f]\u0012LgnZ'be.,'o\u001d+p/JLG/\u001a\u000b\u0005\u0005\u001b\u0012\u0019\u0006E\u0002?\u0005\u001fJ1A!\u0015@\u0005\u001d\u0011un\u001c7fC:DqA!\f,\u0001\u0004\u0011y#A\fnCf\u0014Wm\u0016:ji\u0016$\u0006P\\\"p[BdW\r^5p]R!\u0011\u0011\u0019B-\u0011\u001d\u0011Y\u0006\fa\u0001\u0003O\u000bq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0001\u000fiJL\u0018\t\u001d9f]\u0012$v\u000eT8h)\u0011\t\tM!\u0019\t\u000f\t\rT\u00061\u0001\u0002\u0016\u0006aA\u000f\u001f8M_\u001e\f\u0005\u000f]3oI\u0006Q\u0012\r\u001a3Uq:l\u0015M]6feN$vN\u0011:pW\u0016\u0014\u0018+^3vKRa\u0011\u0011\u0019B5\u0005g\u0012iH!!\u0003\u0004\"9!1\u000e\u0018A\u0002\t5\u0014A\u00039s_\u0012,8-\u001a:JIB\u0019aHa\u001c\n\u0007\tEtH\u0001\u0003M_:<\u0007b\u0002B;]\u0001\u0007!qO\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007y\u0012I(C\u0002\u0003|}\u0012Qa\u00155peRDqAa /\u0001\u0004\u0011y\"\u0001\u0004sKN,H\u000e\u001e\u0005\b\u0005#q\u0003\u0019AAK\u0011\u001d\u0011)I\fa\u0001\u0005\u000f\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0005+j\u0013I\t\u0005\u0003\u0002d\n-\u0015\u0002\u0002BG\u0003C\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0011sK6|g/Z'be.,'o\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002B\nM\u0005b\u0002BK_\u0001\u0007\u0011\u0011O\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\nZ\u0001\u0014e\u0016lwN^3NCJ\\WM]:G_J$\u0006P\u001c\u000b\u0005\u0003\u0003\u0014Y\nC\u0004\u0003\u0012A\u0002\r!!&\t\u000bQL\u0001\u0019A;\t\u000f\u0005\u001d\u0013\u00021\u0001\u0003\"B!!1\u0015BT\u001b\t\u0011)K\u0003\u0003\u0002H\u0005\u0005\u0012\u0002\u0002BU\u0005K\u0013q!T3ue&\u001c7\u000fC\u0003{\u0013\u0001\u00071\u0010C\u0004\u0002\u0012%\u0001\r!a\u0005\t\u000f\u0005e\u0011\u00021\u0001\u0002\u001c!9!1W\u0005A\u0002\tU\u0016A\u00037pO\u000e{g\u000e^3yiB!\u0011Q\u0004B\\\u0013\u0011\u0011I,a\b\u0003\u00151{wmQ8oi\u0016DH\u000f")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements Logging {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final String metricsPackage;
    private final String metricsClassName;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private String metricsPackage() {
        return this.metricsPackage;
    }

    private String metricsClassName() {
        return this.metricsClassName;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    public void shutdown() {
        try {
            super.shutdown();
            this.markersQueuePerBroker().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    private void removeMetrics() {
        TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        int brokerId = broker.id();
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)this.markersQueuePerBroker().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Creating new marker queue map to destination broker " + brokerId);
            return new TxnMarkerQueue(broker);
        });
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Added marker " + pendingCompleteTxnAndMarker.txnMarkerEntry() + " for transactional id " + pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId() + " to destination broker " + brokerId);
    }

    private void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Retry appending " + txnLogAppend + " transaction log");
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(pendingCompleteTxnAndMarkerEntries)));
        CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(pendingCompleteTxnAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$6(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder)request, (RequestCompletionHandler)requestCompletionHandler);
            }
            throw new MatchError(null);
        })).asJavaCollection();
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> "Completed sending transaction markers for " + transactionalId + "; begin transition to " + newMetadata.txnState());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "No longer the coordinator for " + transactionalId + " with coordinator epoch " + coordinatorEpoch + "; cancel appending " + newMetadata + " to transaction log");
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Loading the transaction partition that contains " + transactionalId + " while my current coordinator epoch is " + coordinatorEpoch + "; so cancel appending " + newMetadata + " to transaction log since the loading process will continue the remaining work");
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException("Unhandled error " + unexpectedError + " when fetching current transaction state");
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Sending " + transactionalId + "'s transaction markers for " + txnMetadata + " with coordinator epoch " + coordinatorEpoch + " succeeded, trying to append complete transaction log now");
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> "The cached metadata " + txnMetadata + " has changed to " + epochAndMetadata + " after completed sending the markers with coordinator epoch " + coordinatorEpoch + "; abort transiting the metadata to " + newMetadata + " as it may have been updated by another process");
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected";
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Replaced an existing pending complete txn " + prev + " with " + pendingCompleteTxn + " while adding markers to send.");
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, (Set<TopicPartition>)CollectionConverters$.MODULE$.SetHasAsScala(txnMetadata.topicPartitions()).asScala().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean((Object)txnMetadata.inLock(() -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$hasPendingMarkersToWrite$1(txnMetadata))));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal.noCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable)topicPartition -> OptionConverters$.MODULE$.toScala($this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName())));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        TransactionVersion clientTransactionVersion = pendingCompleteTxn.txnMetadata().clientTransactionVersion();
        short transactionVersion = clientTransactionVersion != null ? clientTransactionVersion.featureLevel() : (short)0;
        partitionsByDestination.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions.toList()).asJava(), transactionVersion);
                        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        String transactionalId = pendingCompleteTxn.transactionalId();
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> "Encountered " + error + " trying to fetch transaction metadata for " + transactionalId + " with coordinator epoch " + coordinatorEpoch + "; cancel sending markers to its partition leaders");
                            return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> "The cached metadata has changed to " + epochAndMetadata + " (old coordinator epoch is " + coordinatorEpoch + ") since preparing to send markers; cancel sending markers to its partition leaders");
                                    return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> "Couldn't find leader endpoint for partitions " + topicPartitions + " while trying to send transaction markers for " + transactionalId + ", these partitions are likely deleted already and hence can be skipped");
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock(() -> {
                                    topicPartitions.foreach((Function1 & Serializable)x$1 -> {
                                        txnMetadata$3.removePartition(x$1);
                                        return BoxedUnit.UNIT;
                                    });
                                    return BoxedUnit.UNIT;
                                });
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected";
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        if (!this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn)) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Failed to remove pending marker entry " + current + " trying to remove " + pendingCompleteTxn);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$1(TransactionMarkerChannelManager $this) {
        return $this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public static final /* synthetic */ int $anonfun$new$2(TransactionMarkerChannelManager $this) {
        return $this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(TransactionMarkerChannelManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$6(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$hasPendingMarkersToWrite$1(TransactionMetadata txnMetadata$2) {
        return !txnMetadata$2.topicPartitions().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Completed transaction for " + txnLogAppend$2.transactionalId() + " with coordinator epoch " + txnLogAppend$2.coordinatorEpoch() + ", final state after commit: " + txnLogAppend$2.txnMetadata().state());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "No longer the coordinator for transactionalId: " + txnLogAppend$2.transactionalId() + " while trying to append to transaction log, skip writing to transaction log");
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Not available to append " + txnLogAppend$2 + ": possible causes include " + Errors.UNKNOWN_TOPIC_OR_PARTITION + ", " + Errors.NOT_ENOUGH_REPLICAS + ", " + Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND + " and " + Errors.REQUEST_TIMED_OUT + "; retry appending");
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Coordinator is loading the partition " + $this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId()) + " and hence cannot complete append of " + txnLogAppend$2 + "; skip writing to transaction log as the loading process should complete it");
            return;
        }
        if (error != null) {
            String errorMsg = "Unexpected error " + error.exceptionName() + " while appending to transaction log for " + txnLogAppend$2.transactionalId();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Removing " + entry + " for txn partition " + txnTopicPartitionId$1 + " to destination broker -1");
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> "Removing " + entry + " for txn partition " + txnTopicPartitionId$1 + " to destination broker " + brokerId$2);
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super("TxnMarkerSenderThread-" + config.brokerId(), (KafkaClient)networkClient, config.requestTimeoutMs(), time);
        this.metricsPackage = "kafka.coordinator.transaction";
        this.metricsClassName = "TransactionMarkerChannelManager";
        this.metricsGroup = new KafkaMetricsGroup(this.metricsPackage(), this.metricsClassName());
        this.logIdent_$eq("[Transaction Marker Channel Manager " + config.brokerId() + "]: ");
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$UnknownDestinationQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$LogAppendRetryQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger((int)TransactionMarkerChannelManager.$anonfun$new$2(this)));
    }
}

