/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;

public class TimingWheelExpirationService
implements ExpirationService {
    private static final long WORK_TIMEOUT_MS = 200L;
    private final ExpiredOperationReaper expirationReaper;
    private final Timer timer;

    public TimingWheelExpirationService(Timer timer) {
        this.timer = timer;
        this.expirationReaper = new ExpiredOperationReaper();
        this.expirationReaper.start();
    }

    @Override
    public <T> CompletableFuture<T> failAfter(long timeoutMs) {
        TimerTaskCompletableFuture task = new TimerTaskCompletableFuture(timeoutMs);
        task.future.whenComplete((t, throwable) -> task.cancel());
        this.timer.add(task);
        return task.future;
    }

    public void shutdown() throws InterruptedException {
        this.expirationReaper.shutdown();
    }

    private class ExpiredOperationReaper
    extends ShutdownableThread {
        ExpiredOperationReaper() {
            super("raft-expiration-reaper", false);
        }

        public void doWork() {
            try {
                TimingWheelExpirationService.this.timer.advanceClock(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TimerTaskCompletableFuture<T>
    extends TimerTask {
        private final CompletableFuture<T> future = new CompletableFuture();

        TimerTaskCompletableFuture(long delayMs) {
            super(delayMs);
        }

        public void run() {
            this.future.completeExceptionally((Throwable)new TimeoutException("Future failed to be completed before timeout of " + this.delayMs + " ms was reached"));
        }
    }
}

